/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import org.apache.flink.runtime.state.StateSnapshotTransformer;

public interface StateEntry<K, N, S> {
    public K getKey();

    public N getNamespace();

    public S getState();

    default public StateEntry<K, N, S> filterOrTransform(StateSnapshotTransformer<S> transformer) {
        S newState = transformer.filterOrTransform(this.getState());
        if (newState != null) {
            return new SimpleStateEntry<K, N, S>(this.getKey(), this.getNamespace(), newState);
        }
        return null;
    }

    public static class SimpleStateEntry<K, N, S>
    implements StateEntry<K, N, S> {
        private final K key;
        private final N namespace;
        private final S value;

        public SimpleStateEntry(K key, N namespace, S value) {
            this.key = key;
            this.namespace = namespace;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public N getNamespace() {
            return this.namespace;
        }

        @Override
        public S getState() {
            return this.value;
        }
    }
}

