/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.iterative.concurrent;

public class SuperstepKickoffLatch {
    private final Object monitor = new Object();
    private int superstepNumber = 1;
    private boolean terminated;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerNextSuperstep() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.terminated) {
                throw new IllegalStateException("Already terminated.");
            }
            ++this.superstepNumber;
            this.monitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalTermination() {
        Object object = this.monitor;
        synchronized (object) {
            this.terminated = true;
            this.monitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean awaitStartOfSuperstepOrTermination(int superstep) throws InterruptedException {
        while (true) {
            Object object = this.monitor;
            synchronized (object) {
                if (this.terminated) {
                    return true;
                }
                if (this.superstepNumber == superstep) {
                    return false;
                }
                if (this.superstepNumber != superstep - 1) {
                    throw new IllegalStateException("Error while waiting for start of next superstep. current= " + this.superstepNumber + " waitingFor=" + superstep);
                }
                this.monitor.wait(2000L);
            }
        }
    }
}

