/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;
import org.apache.flink.runtime.rest.messages.JobExceptionsInfo;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.util.Preconditions;

public class JobExceptionsInfoWithHistory
extends JobExceptionsInfo
implements ResponseBody {
    public static final String FIELD_NAME_EXCEPTION_HISTORY = "exceptionHistory";
    @JsonProperty(value="exceptionHistory")
    private final JobExceptionHistory exceptionHistory;

    @JsonCreator
    public JobExceptionsInfoWithHistory(@JsonProperty(value="root-exception") String rootException, @JsonProperty(value="timestamp") Long rootTimestamp, @JsonProperty(value="all-exceptions") List<JobExceptionsInfo.ExecutionExceptionInfo> allExceptions, @JsonProperty(value="truncated") boolean truncated, @JsonProperty(value="exceptionHistory") JobExceptionHistory exceptionHistory) {
        super(rootException, rootTimestamp, allExceptions, truncated);
        this.exceptionHistory = exceptionHistory;
    }

    public JobExceptionsInfoWithHistory() {
        this(null, null, Collections.emptyList(), false, new JobExceptionHistory(Collections.emptyList(), false));
    }

    @JsonIgnore
    public JobExceptionHistory getExceptionHistory() {
        return this.exceptionHistory;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobExceptionsInfoWithHistory that = (JobExceptionsInfoWithHistory)o;
        return this.isTruncated() == that.isTruncated() && Objects.equals(this.getRootException(), that.getRootException()) && Objects.equals(this.getRootTimestamp(), that.getRootTimestamp()) && Objects.equals(this.getAllExceptions(), that.getAllExceptions()) && Objects.equals(this.exceptionHistory, that.exceptionHistory);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.isTruncated(), this.getRootException(), this.getRootTimestamp(), this.getAllExceptions(), this.exceptionHistory);
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", JobExceptionsInfoWithHistory.class.getSimpleName() + "[", "]").add("rootException='" + this.getRootException() + "'").add("rootTimestamp=" + this.getRootTimestamp()).add("allExceptions=" + this.getAllExceptions()).add("truncated=" + this.isTruncated()).add("exceptionHistory=" + this.exceptionHistory).toString();
    }

    public static class RootExceptionInfo
    extends ExceptionInfo {
        public static final String FIELD_NAME_CONCURRENT_EXCEPTIONS = "concurrentExceptions";
        @JsonProperty(value="concurrentExceptions")
        private final Collection<ExceptionInfo> concurrentExceptions;

        public RootExceptionInfo(String exceptionName, String stacktrace, long timestamp, Collection<ExceptionInfo> concurrentExceptions) {
            this(exceptionName, stacktrace, timestamp, null, null, concurrentExceptions);
        }

        @JsonCreator
        public RootExceptionInfo(@JsonProperty(value="exceptionName") String exceptionName, @JsonProperty(value="stacktrace") String stacktrace, @JsonProperty(value="timestamp") long timestamp, @JsonProperty(value="taskName") @Nullable String taskName, @JsonProperty(value="location") @Nullable String location, @JsonProperty(value="concurrentExceptions") Collection<ExceptionInfo> concurrentExceptions) {
            super(exceptionName, stacktrace, timestamp, taskName, location);
            this.concurrentExceptions = concurrentExceptions;
        }

        @JsonIgnore
        public Collection<ExceptionInfo> getConcurrentExceptions() {
            return this.concurrentExceptions;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass() || !super.equals(o)) {
                return false;
            }
            RootExceptionInfo that = (RootExceptionInfo)o;
            return this.getConcurrentExceptions().equals(that.getConcurrentExceptions());
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.getConcurrentExceptions());
        }

        @Override
        public String toString() {
            return new StringJoiner(", ", RootExceptionInfo.class.getSimpleName() + "[", "]").add("exceptionName='" + this.getExceptionName() + "'").add("stacktrace='" + this.getStacktrace() + "'").add("timestamp=" + this.getTimestamp()).add("taskName='" + this.getTaskName() + "'").add("location='" + this.getLocation() + "'").add("concurrentExceptions=" + this.getConcurrentExceptions()).toString();
        }
    }

    public static class ExceptionInfo {
        public static final String FIELD_NAME_EXCEPTION_NAME = "exceptionName";
        public static final String FIELD_NAME_EXCEPTION_STACKTRACE = "stacktrace";
        public static final String FIELD_NAME_EXCEPTION_TIMESTAMP = "timestamp";
        public static final String FIELD_NAME_TASK_NAME = "taskName";
        public static final String FIELD_NAME_LOCATION = "location";
        @JsonProperty(value="exceptionName")
        private final String exceptionName;
        @JsonProperty(value="stacktrace")
        private final String stacktrace;
        @JsonProperty(value="timestamp")
        private final long timestamp;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonProperty(value="taskName")
        @Nullable
        private final String taskName;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonProperty(value="location")
        @Nullable
        private final String location;

        public ExceptionInfo(String exceptionName, String stacktrace, long timestamp) {
            this(exceptionName, stacktrace, timestamp, null, null);
        }

        @JsonCreator
        public ExceptionInfo(@JsonProperty(value="exceptionName") String exceptionName, @JsonProperty(value="stacktrace") String stacktrace, @JsonProperty(value="timestamp") long timestamp, @JsonProperty(value="taskName") @Nullable String taskName, @JsonProperty(value="location") @Nullable String location) {
            this.exceptionName = (String)Preconditions.checkNotNull((Object)exceptionName);
            this.stacktrace = (String)Preconditions.checkNotNull((Object)stacktrace);
            this.timestamp = timestamp;
            this.taskName = taskName;
            this.location = location;
        }

        @JsonIgnore
        public String getExceptionName() {
            return this.exceptionName;
        }

        @JsonIgnore
        public String getStacktrace() {
            return this.stacktrace;
        }

        @JsonIgnore
        public long getTimestamp() {
            return this.timestamp;
        }

        @JsonIgnore
        @Nullable
        public String getTaskName() {
            return this.taskName;
        }

        @JsonIgnore
        @Nullable
        public String getLocation() {
            return this.location;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExceptionInfo that = (ExceptionInfo)o;
            return this.exceptionName.equals(that.exceptionName) && this.stacktrace.equals(that.stacktrace) && Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.taskName, that.taskName) && Objects.equals(this.location, that.location);
        }

        public int hashCode() {
            return Objects.hash(this.exceptionName, this.stacktrace, this.timestamp, this.taskName, this.location);
        }

        public String toString() {
            return new StringJoiner(", ", ExceptionInfo.class.getSimpleName() + "[", "]").add("exceptionName='" + this.exceptionName + "'").add("stacktrace='" + this.stacktrace + "'").add("timestamp=" + this.timestamp).add("taskName='" + this.taskName + "'").add("location='" + this.location + "'").toString();
        }
    }

    public static final class JobExceptionHistory {
        public static final String FIELD_NAME_ENTRIES = "entries";
        public static final String FIELD_NAME_TRUNCATED = "truncated";
        @JsonProperty(value="entries")
        private final List<RootExceptionInfo> entries;
        @JsonProperty(value="truncated")
        private final boolean truncated;

        @JsonCreator
        public JobExceptionHistory(@JsonProperty(value="entries") List<RootExceptionInfo> entries, @JsonProperty(value="truncated") boolean truncated) {
            this.entries = entries;
            this.truncated = truncated;
        }

        @JsonIgnore
        public List<RootExceptionInfo> getEntries() {
            return this.entries;
        }

        @JsonIgnore
        public boolean isTruncated() {
            return this.truncated;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JobExceptionHistory that = (JobExceptionHistory)o;
            return this.isTruncated() == that.isTruncated() && Objects.equals(this.entries, that.entries);
        }

        public int hashCode() {
            return Objects.hash(this.entries, this.truncated);
        }

        public String toString() {
            return new StringJoiner(", ", JobExceptionHistory.class.getSimpleName() + "[", "]").add("entries=" + this.entries).add("truncated=" + this.truncated).toString();
        }
    }
}

