/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.minicluster;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.api.common.accumulators.AccumulatorHelper;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.jobmaster.JobResult;
import org.apache.flink.runtime.minicluster.MiniCluster;
import org.apache.flink.runtime.operators.coordination.CoordinationRequest;
import org.apache.flink.runtime.operators.coordination.CoordinationRequestGateway;
import org.apache.flink.runtime.operators.coordination.CoordinationResponse;
import org.apache.flink.util.SerializedValue;
import org.apache.flink.util.concurrent.FutureUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MiniClusterJobClient
implements JobClient,
CoordinationRequestGateway {
    private static final Logger LOG = LoggerFactory.getLogger(MiniClusterJobClient.class);
    private final JobID jobID;
    private final MiniCluster miniCluster;
    private final ClassLoader classLoader;
    private final CompletableFuture<JobResult> jobResultFuture;

    public MiniClusterJobClient(JobID jobID, MiniCluster miniCluster, ClassLoader classLoader, JobFinalizationBehavior finalizationBehaviour) {
        this.jobID = jobID;
        this.miniCluster = miniCluster;
        this.classLoader = classLoader;
        if (finalizationBehaviour == JobFinalizationBehavior.SHUTDOWN_CLUSTER) {
            this.jobResultFuture = miniCluster.requestJobResult(jobID).whenComplete((result, throwable) -> MiniClusterJobClient.shutDownCluster(miniCluster));
        } else if (finalizationBehaviour == JobFinalizationBehavior.NOTHING) {
            this.jobResultFuture = miniCluster.requestJobResult(jobID);
        } else {
            throw new IllegalArgumentException("Unexpected shutdown behavior: " + (Object)((Object)finalizationBehaviour));
        }
    }

    public JobID getJobID() {
        return this.jobID;
    }

    public CompletableFuture<JobStatus> getJobStatus() {
        return this.miniCluster.getJobStatus(this.jobID);
    }

    public CompletableFuture<Void> cancel() {
        return this.miniCluster.cancelJob(this.jobID).thenAccept(result -> {});
    }

    public CompletableFuture<String> stopWithSavepoint(boolean terminate, @Nullable String savepointDirectory) {
        return this.miniCluster.stopWithSavepoint(this.jobID, savepointDirectory, terminate);
    }

    public CompletableFuture<String> triggerSavepoint(@Nullable String savepointDirectory) {
        return this.miniCluster.triggerSavepoint(this.jobID, savepointDirectory, false);
    }

    public CompletableFuture<Map<String, Object>> getAccumulators() {
        CompletableFuture<JobExecutionResult> jobExecutionResult = this.getJobExecutionResult();
        if (jobExecutionResult.isDone()) {
            return jobExecutionResult.thenApply(JobExecutionResult::getAllAccumulatorResults);
        }
        return ((CompletableFuture)this.miniCluster.getExecutionGraph(this.jobID).thenApply(AccessExecutionGraph::getAccumulatorsSerialized)).thenApply(accumulators -> {
            try {
                return AccumulatorHelper.deserializeAndUnwrapAccumulators((Map)accumulators, (ClassLoader)this.classLoader);
            }
            catch (Exception e) {
                throw new CompletionException("Cannot deserialize and unwrap accumulators properly.", e);
            }
        });
    }

    public CompletableFuture<JobExecutionResult> getJobExecutionResult() {
        return this.jobResultFuture.thenApply(result -> {
            try {
                return result.toJobExecutionResult(this.classLoader);
            }
            catch (Exception e) {
                throw new CompletionException("Failed to convert JobResult to JobExecutionResult.", e);
            }
        });
    }

    @Override
    public CompletableFuture<CoordinationResponse> sendCoordinationRequest(OperatorID operatorId, CoordinationRequest request) {
        try {
            SerializedValue serializedRequest = new SerializedValue((Object)request);
            return this.miniCluster.deliverCoordinationRequestToCoordinator(this.jobID, operatorId, (SerializedValue<CoordinationRequest>)serializedRequest);
        }
        catch (IOException e) {
            return FutureUtils.completedExceptionally((Throwable)e);
        }
    }

    private static void shutDownCluster(MiniCluster miniCluster) {
        miniCluster.closeAsync().whenComplete((ignored, throwable) -> {
            if (throwable != null) {
                LOG.warn("Shutdown of MiniCluster failed.", throwable);
            }
        });
    }

    public static enum JobFinalizationBehavior {
        SHUTDOWN_CLUSTER,
        NOTHING;

    }
}

