/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.source.coordinator;

import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorNotifier
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutorNotifier.class);
    private final ScheduledExecutorService workerExecutor;
    private final Executor executorToNotify;
    private final AtomicBoolean closed;

    public ExecutorNotifier(ScheduledExecutorService workerExecutor, Executor executorToNotify) {
        this.executorToNotify = executorToNotify;
        this.workerExecutor = workerExecutor;
        this.closed = new AtomicBoolean(false);
    }

    public <T> void notifyReadyAsync(Callable<T> callable, BiConsumer<T, Throwable> handler) {
        this.workerExecutor.execute(() -> {
            try {
                Object result = callable.call();
                this.executorToNotify.execute(() -> handler.accept(result, null));
            }
            catch (Throwable t) {
                this.executorToNotify.execute(() -> handler.accept(null, t));
            }
        });
    }

    public <T> void notifyReadyAsync(Callable<T> callable, BiConsumer<T, Throwable> handler, long initialDelayMs, long periodMs) {
        this.workerExecutor.scheduleAtFixedRate(() -> {
            try {
                Object result = callable.call();
                this.executorToNotify.execute(() -> handler.accept(result, null));
            }
            catch (Throwable t) {
                this.executorToNotify.execute(() -> handler.accept(null, t));
            }
        }, initialDelayMs, periodMs, TimeUnit.MILLISECONDS);
    }

    @Override
    public void close() throws InterruptedException {
        if (!this.closed.compareAndSet(false, true)) {
            LOG.debug("The executor notifier has been closed.");
            return;
        }
        this.workerExecutor.shutdownNow();
        this.workerExecutor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
    }
}

