/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager;

import java.io.IOException;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.InstantiationUtil;

public class InputSplitWrapper
implements IOReadableWritable {
    private InputSplit split;
    private byte[] splitData;

    public InputSplitWrapper() {
    }

    public InputSplitWrapper(InputSplit split) throws Exception {
        this.split = split;
        this.splitData = InstantiationUtil.serializeObject((Object)split);
    }

    public InputSplit getSplit(ClassLoader userCodeClassLoader) throws ClassNotFoundException, IOException {
        if (this.split == null) {
            if (this.splitData == null) {
                throw new IllegalStateException("No split or split data available");
            }
            this.split = (InputSplit)InstantiationUtil.deserializeObject((byte[])this.splitData, (ClassLoader)userCodeClassLoader);
        }
        return this.split;
    }

    public void read(DataInputView in) throws IOException {
        int len = in.readInt();
        this.splitData = new byte[len];
        in.readFully(this.splitData);
        this.split = null;
    }

    public void write(DataOutputView out) throws IOException {
        out.writeInt(this.splitData.length);
        out.write(this.splitData);
    }
}

