/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network;

import org.apache.flink.runtime.io.network.ConnectionInfoLookupResponse;
import org.apache.flink.runtime.io.network.RemoteReceiver;
import org.apache.flink.runtime.io.network.channels.ChannelID;

public class EnvelopeReceiverList {
    private final ChannelID localReceiver;
    private final RemoteReceiver remoteReceiver;

    public EnvelopeReceiverList(ConnectionInfoLookupResponse cilr) {
        this.localReceiver = cilr.getLocalTarget();
        this.remoteReceiver = cilr.getRemoteTarget();
    }

    public EnvelopeReceiverList(ChannelID localReceiver) {
        this.localReceiver = localReceiver;
        this.remoteReceiver = null;
    }

    public EnvelopeReceiverList(RemoteReceiver remoteReceiver) {
        this.localReceiver = null;
        this.remoteReceiver = remoteReceiver;
    }

    public boolean hasLocalReceiver() {
        return this.localReceiver != null;
    }

    public boolean hasRemoteReceiver() {
        return this.remoteReceiver != null;
    }

    public int getTotalNumberOfReceivers() {
        return (this.localReceiver == null ? 0 : 1) + (this.remoteReceiver == null ? 0 : 1);
    }

    public RemoteReceiver getRemoteReceiver() {
        return this.remoteReceiver;
    }

    public ChannelID getLocalReceiver() {
        return this.localReceiver;
    }

    public String toString() {
        return "local receiver: " + this.localReceiver + ", remote receiver: " + this.remoteReceiver;
    }
}

