/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.disk.iomanager;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.disk.iomanager.AsynchronousFileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.BulkBlockChannelReader;
import org.apache.flink.runtime.io.disk.iomanager.FileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.ReadRequest;
import org.apache.flink.runtime.io.disk.iomanager.RequestDoneCallback;
import org.apache.flink.runtime.io.disk.iomanager.RequestQueue;
import org.apache.flink.runtime.io.disk.iomanager.SegmentReadRequest;

public class AsynchronousBulkBlockReader
extends AsynchronousFileIOChannel<ReadRequest>
implements BulkBlockChannelReader {
    private final ArrayList<MemorySegment> returnBuffers;

    protected AsynchronousBulkBlockReader(FileIOChannel.ID channelID, RequestQueue<ReadRequest> requestQueue, List<MemorySegment> sourceSegments, int numBlocks) throws IOException {
        this(channelID, requestQueue, sourceSegments, numBlocks, new ArrayList<MemorySegment>(numBlocks));
    }

    private AsynchronousBulkBlockReader(FileIOChannel.ID channelID, RequestQueue<ReadRequest> requestQueue, List<MemorySegment> sourceSegments, int numBlocks, ArrayList<MemorySegment> target) throws IOException {
        super(channelID, requestQueue, new CollectingCallback(target), false);
        this.returnBuffers = target;
        if (sourceSegments.size() < numBlocks) {
            throw new IllegalArgumentException("The list of source memory segments must contain at least as many segments as the number of blocks to read.");
        }
        for (int i = 0; i < numBlocks; ++i) {
            this.readBlock(sourceSegments.remove(sourceSegments.size() - 1));
        }
    }

    private void readBlock(MemorySegment segment) throws IOException {
        this.checkErroneous();
        this.requestsNotReturned.incrementAndGet();
        if (this.closed || this.requestQueue.isClosed()) {
            this.requestsNotReturned.decrementAndGet();
            throw new IOException("The reader has been closed.");
        }
        this.requestQueue.add(new SegmentReadRequest(this, segment));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MemorySegment> getFullSegments() {
        Object object = this.closeLock;
        synchronized (object) {
            if (!this.isClosed() || this.requestsNotReturned.get() > 0) {
                throw new IllegalStateException("Full segments can only be obtained after the reader was properly closed.");
            }
        }
        return this.returnBuffers;
    }

    private static final class CollectingCallback
    implements RequestDoneCallback {
        private final ArrayList<MemorySegment> list;

        public CollectingCallback(ArrayList<MemorySegment> list) {
            this.list = list;
        }

        @Override
        public void requestSuccessful(MemorySegment buffer) {
            this.list.add(buffer);
        }

        @Override
        public void requestFailed(MemorySegment buffer, IOException e) {
            this.list.add(buffer);
        }
    }
}

