/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.disk.iomanager;

import java.io.IOException;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.disk.iomanager.AsynchronousFileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.BlockChannelWriterWithCallback;
import org.apache.flink.runtime.io.disk.iomanager.FileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.RequestDoneCallback;
import org.apache.flink.runtime.io.disk.iomanager.RequestQueue;
import org.apache.flink.runtime.io.disk.iomanager.SegmentWriteRequest;
import org.apache.flink.runtime.io.disk.iomanager.WriteRequest;

public class AsynchronousBlockWriterWithCallback
extends AsynchronousFileIOChannel<WriteRequest>
implements BlockChannelWriterWithCallback {
    protected AsynchronousBlockWriterWithCallback(FileIOChannel.ID channelID, RequestQueue<WriteRequest> requestQueue, RequestDoneCallback callback) throws IOException {
        super(channelID, requestQueue, callback, true);
    }

    @Override
    public void writeBlock(MemorySegment segment) throws IOException {
        this.checkErroneous();
        this.requestsNotReturned.incrementAndGet();
        if (this.closed || this.requestQueue.isClosed()) {
            this.requestsNotReturned.decrementAndGet();
            throw new IOException("The writer has been closed.");
        }
        this.requestQueue.add(new SegmentWriteRequest(this, segment));
    }
}

