/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.flink.runtime.JobException;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.deployment.GateDeploymentDescriptor;
import org.apache.flink.runtime.deployment.TaskDeploymentDescriptor;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionEdge;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.IntermediateResult;
import org.apache.flink.runtime.executiongraph.IntermediateResultPartition;
import org.apache.flink.runtime.instance.Instance;
import org.apache.flink.runtime.instance.SimpleSlot;
import org.apache.flink.runtime.jobgraph.DistributionPattern;
import org.apache.flink.runtime.jobgraph.JobEdge;
import org.apache.flink.runtime.jobgraph.JobID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationConstraint;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationGroup;
import org.apache.flink.runtime.jobmanager.scheduler.NoResourceAvailableException;
import org.apache.flink.runtime.jobmanager.scheduler.Scheduler;
import org.slf4j.Logger;

public class ExecutionVertex {
    private static final Logger LOG = ExecutionGraph.LOG;
    private static final int MAX_DISTINCT_LOCATIONS_TO_CONSIDER = 8;
    private final ExecutionJobVertex jobVertex;
    private final IntermediateResultPartition[] resultPartitions;
    private final ExecutionEdge[][] inputEdges;
    private final int subTaskIndex;
    private final List<Execution> priorExecutions;
    private volatile CoLocationConstraint locationConstraint;
    private volatile Execution currentExecution;

    public ExecutionVertex(ExecutionJobVertex jobVertex, int subTaskIndex, IntermediateResult[] producedDataSets) {
        this(jobVertex, subTaskIndex, producedDataSets, System.currentTimeMillis());
    }

    public ExecutionVertex(ExecutionJobVertex jobVertex, int subTaskIndex, IntermediateResult[] producedDataSets, long createTimestamp) {
        this.jobVertex = jobVertex;
        this.subTaskIndex = subTaskIndex;
        this.resultPartitions = new IntermediateResultPartition[producedDataSets.length];
        for (int i = 0; i < producedDataSets.length; ++i) {
            IntermediateResultPartition irp;
            this.resultPartitions[i] = irp = new IntermediateResultPartition(producedDataSets[i], this, subTaskIndex);
            producedDataSets[i].setPartition(subTaskIndex, irp);
        }
        this.inputEdges = new ExecutionEdge[jobVertex.getJobVertex().getInputs().size()][];
        this.priorExecutions = new CopyOnWriteArrayList<Execution>();
        this.currentExecution = new Execution(this, 0, createTimestamp);
        CoLocationGroup clg = jobVertex.getCoLocationGroup();
        this.locationConstraint = clg != null ? clg.getLocationConstraint(subTaskIndex) : null;
    }

    public JobID getJobId() {
        return this.jobVertex.getJobId();
    }

    public ExecutionJobVertex getJobVertex() {
        return this.jobVertex;
    }

    public JobVertexID getJobvertexId() {
        return this.jobVertex.getJobVertexId();
    }

    public String getTaskName() {
        return this.jobVertex.getJobVertex().getName();
    }

    public int getTotalNumberOfParallelSubtasks() {
        return this.jobVertex.getParallelism();
    }

    public int getParallelSubtaskIndex() {
        return this.subTaskIndex;
    }

    public int getNumberOfInputs() {
        return this.inputEdges.length;
    }

    public ExecutionEdge[] getInputEdges(int input) {
        if (input < 0 || input >= this.inputEdges.length) {
            throw new IllegalArgumentException(String.format("Input %d is out of range [0..%d)", input, this.inputEdges.length));
        }
        return this.inputEdges[input];
    }

    public CoLocationConstraint getLocationConstraint() {
        return this.locationConstraint;
    }

    public Execution getCurrentExecutionAttempt() {
        return this.currentExecution;
    }

    public ExecutionState getExecutionState() {
        return this.currentExecution.getState();
    }

    public long getStateTimestamp(ExecutionState state) {
        return this.currentExecution.getStateTimestamp(state);
    }

    public Throwable getFailureCause() {
        return this.currentExecution.getFailureCause();
    }

    public SimpleSlot getCurrentAssignedResource() {
        return this.currentExecution.getAssignedResource();
    }

    public ExecutionGraph getExecutionGraph() {
        return this.jobVertex.getGraph();
    }

    public void connectSource(int inputNumber, IntermediateResult source, JobEdge edge, int consumerNumber) {
        DistributionPattern pattern = edge.getDistributionPattern();
        IntermediateResultPartition[] sourcePartitions = source.getPartitions();
        ExecutionEdge[] edges = null;
        switch (pattern) {
            case POINTWISE: {
                edges = this.connectPointwise(sourcePartitions, inputNumber);
                break;
            }
            case BIPARTITE: {
                edges = this.connectAllToAll(sourcePartitions, inputNumber);
                break;
            }
            default: {
                throw new RuntimeException("Unrecognized distribution pattern.");
            }
        }
        this.inputEdges[inputNumber] = edges;
        ExecutionGraph graph = this.getExecutionGraph();
        for (ExecutionEdge ee : edges) {
            ee.getSource().addConsumer(ee, consumerNumber);
            graph.registerExecutionEdge(ee);
        }
    }

    private ExecutionEdge[] connectAllToAll(IntermediateResultPartition[] sourcePartitions, int inputNumber) {
        ExecutionEdge[] edges = new ExecutionEdge[sourcePartitions.length];
        for (int i = 0; i < sourcePartitions.length; ++i) {
            IntermediateResultPartition irp = sourcePartitions[i];
            edges[i] = new ExecutionEdge(irp, this, inputNumber);
        }
        return edges;
    }

    private ExecutionEdge[] connectPointwise(IntermediateResultPartition[] sourcePartitions, int inputNumber) {
        int numSources = sourcePartitions.length;
        int parallelism = this.getTotalNumberOfParallelSubtasks();
        if (numSources == parallelism) {
            return new ExecutionEdge[]{new ExecutionEdge(sourcePartitions[this.subTaskIndex], this, inputNumber)};
        }
        if (numSources < parallelism) {
            int sourcePartition;
            if (parallelism % numSources == 0) {
                int factor = parallelism / numSources;
                sourcePartition = this.subTaskIndex / factor;
            } else {
                float factor = (float)parallelism / (float)numSources;
                sourcePartition = (int)((float)this.subTaskIndex / factor);
            }
            return new ExecutionEdge[]{new ExecutionEdge(sourcePartitions[sourcePartition], this, inputNumber)};
        }
        if (numSources % parallelism == 0) {
            int factor = numSources / parallelism;
            int startIndex = this.subTaskIndex * factor;
            ExecutionEdge[] edges = new ExecutionEdge[factor];
            for (int i = 0; i < factor; ++i) {
                edges[i] = new ExecutionEdge(sourcePartitions[startIndex + i], this, inputNumber);
            }
            return edges;
        }
        float factor = (float)numSources / (float)parallelism;
        int start = (int)((float)this.subTaskIndex * factor);
        int end = this.subTaskIndex == this.getTotalNumberOfParallelSubtasks() - 1 ? sourcePartitions.length : (int)((float)(this.subTaskIndex + 1) * factor);
        ExecutionEdge[] edges = new ExecutionEdge[end - start];
        for (int i = 0; i < edges.length; ++i) {
            edges[i] = new ExecutionEdge(sourcePartitions[start + i], this, inputNumber);
        }
        return edges;
    }

    public Iterable<Instance> getPreferredLocations() {
        HashSet<Instance> locations = new HashSet<Instance>();
        for (int i = 0; i < this.inputEdges.length; ++i) {
            ExecutionEdge[] sources = this.inputEdges[i];
            if (sources == null) continue;
            for (int k = 0; k < sources.length; ++k) {
                SimpleSlot sourceSlot = sources[k].getSource().getProducer().getCurrentAssignedResource();
                if (sourceSlot == null) continue;
                locations.add(sourceSlot.getInstance());
                if (locations.size() <= 8) continue;
                return null;
            }
        }
        return locations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetForNewExecution() {
        List<Execution> list = this.priorExecutions;
        synchronized (list) {
            Execution execution = this.currentExecution;
            ExecutionState state = execution.getState();
            if (state == ExecutionState.FINISHED || state == ExecutionState.CANCELED || state == ExecutionState.FAILED) {
                this.priorExecutions.add(execution);
                this.currentExecution = new Execution(this, execution.getAttemptNumber() + 1, System.currentTimeMillis());
                CoLocationGroup grp = this.jobVertex.getCoLocationGroup();
                if (grp != null) {
                    this.locationConstraint = grp.getLocationConstraint(this.subTaskIndex);
                }
                ExecutionGraph graph = this.getExecutionGraph();
                ExecutionEdge[][] arr$ = this.inputEdges;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    ExecutionEdge[] input;
                    for (ExecutionEdge e : input = arr$[i$]) {
                        e.assignNewChannelIDs();
                        graph.registerExecutionEdge(e);
                    }
                }
            } else {
                throw new IllegalStateException("Cannot reset a vertex that is in state " + (Object)((Object)state));
            }
        }
    }

    public void scheduleForExecution(Scheduler scheduler, boolean queued) throws NoResourceAvailableException {
        this.currentExecution.scheduleForExecution(scheduler, queued);
    }

    public void deployToSlot(SimpleSlot slot) throws JobException {
        this.currentExecution.deployToSlot(slot);
    }

    public void cancel() {
        this.currentExecution.cancel();
    }

    public void fail(Throwable t) {
        this.currentExecution.fail(t);
    }

    void executionFinished() {
        this.jobVertex.vertexFinished(this.subTaskIndex);
    }

    void executionCanceled() {
        this.jobVertex.vertexCancelled(this.subTaskIndex);
    }

    void executionFailed(Throwable t) {
        this.jobVertex.vertexFailed(this.subTaskIndex, t);
    }

    void notifyStateTransition(ExecutionAttemptID executionId, ExecutionState newState, Throwable error) {
        this.getExecutionGraph().notifyExecutionChange(this.getJobvertexId(), this.subTaskIndex, executionId, newState, error);
    }

    TaskDeploymentDescriptor createDeploymentDescriptor(ExecutionAttemptID executionId, SimpleSlot slot) {
        ArrayList<GateDeploymentDescriptor> inputGates = new ArrayList<GateDeploymentDescriptor>(this.inputEdges.length);
        for (ExecutionEdge[] channels : this.inputEdges) {
            inputGates.add(GateDeploymentDescriptor.fromEdges(channels));
        }
        ArrayList<GateDeploymentDescriptor> outputGates = new ArrayList<GateDeploymentDescriptor>(this.resultPartitions.length);
        for (IntermediateResultPartition partition : this.resultPartitions) {
            for (List<ExecutionEdge> channels : partition.getConsumers()) {
                outputGates.add(GateDeploymentDescriptor.fromEdges(channels));
            }
        }
        List<BlobKey> jarFiles = this.getExecutionGraph().getRequiredJarFiles();
        return new TaskDeploymentDescriptor(this.getJobId(), this.getJobvertexId(), executionId, this.getTaskName(), this.subTaskIndex, this.getTotalNumberOfParallelSubtasks(), this.getExecutionGraph().getJobConfiguration(), this.jobVertex.getJobVertex().getConfiguration(), this.jobVertex.getJobVertex().getInvokableClassName(), outputGates, inputGates, jarFiles, slot.getSlotNumber());
    }

    public void execute(Runnable action) {
        this.jobVertex.execute(action);
    }

    public String getSimpleName() {
        return this.getTaskName() + " (" + (this.getParallelSubtaskIndex() + 1) + '/' + this.getTotalNumberOfParallelSubtasks() + ')';
    }

    public String toString() {
        return this.getSimpleName();
    }
}

