/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.BlobService;
import org.apache.flink.runtime.jobgraph.JobID;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import org.apache.flink.shaded.com.google.common.io.BaseEncoding;
import org.slf4j.Logger;

public class BlobUtils {
    private static final String HASHING_ALGORITHM = "SHA-1";
    private static final String BLOB_FILE_PREFIX = "blob_";
    private static final String JOB_DIR_PREFIX = "job_";
    static final Charset DEFAULT_CHARSET = Charset.forName("utf-8");

    static File initStorageDirectory(String storageDirectory) {
        File baseDir = storageDirectory != null ? new File(storageDirectory) : new File(System.getProperty("java.io.tmpdir"));
        int MAX_ATTEMPTS = 10;
        for (int attempt = 0; attempt < 10; ++attempt) {
            File storageDir = new File(baseDir, String.format("blobStore-%s", UUID.randomUUID().toString()));
            if (storageDir.exists() || !storageDir.mkdirs()) continue;
            return storageDir;
        }
        throw new RuntimeException("Could not create storage directory for BLOB store in '" + baseDir + "'.");
    }

    static File getIncomingDirectory(File storageDir) {
        File incomingDirectory = new File(storageDir, "incoming");
        incomingDirectory.mkdir();
        return incomingDirectory;
    }

    private static File getCacheDirectory(File storageDir) {
        File cacheDirectory = new File(storageDir, "cache");
        if (!cacheDirectory.exists() && !cacheDirectory.mkdir()) {
            throw new RuntimeException("Could not create cache directory '" + cacheDirectory + "'.");
        }
        return cacheDirectory;
    }

    static File getStorageLocation(File storageDir, BlobKey key) {
        return new File(BlobUtils.getCacheDirectory(storageDir), BLOB_FILE_PREFIX + key.toString());
    }

    static File getStorageLocation(File storageDir, JobID jobID, String key) {
        return new File(BlobUtils.getJobDirectory(storageDir, jobID), BLOB_FILE_PREFIX + BlobUtils.encodeKey(key));
    }

    private static File getJobDirectory(File storageDir, JobID jobID) {
        File jobDirectory = new File(storageDir, JOB_DIR_PREFIX + jobID.toString());
        jobDirectory.mkdirs();
        return jobDirectory;
    }

    private static String encodeKey(String key) {
        return BaseEncoding.base64().encode(key.getBytes(DEFAULT_CHARSET));
    }

    static void deleteJobDirectory(File storageDir, JobID jobID) throws IOException {
        File directory = BlobUtils.getJobDirectory(storageDir, jobID);
        FileUtils.deleteDirectory((File)directory);
    }

    static MessageDigest createMessageDigest() {
        try {
            return MessageDigest.getInstance(HASHING_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Cannot instantiate the message digest algorithm SHA-1", e);
        }
    }

    static Thread addShutdownHook(final BlobService service, final Logger logger) {
        Preconditions.checkNotNull((Object)service);
        Preconditions.checkNotNull((Object)logger);
        Thread shutdownHook = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    service.shutdown();
                }
                catch (Throwable t) {
                    logger.error("Error during shutdown of blob service via JVM shutdown hook: " + t.getMessage(), t);
                }
            }
        });
        try {
            Runtime.getRuntime().addShutdownHook(shutdownHook);
            return shutdownHook;
        }
        catch (IllegalStateException e) {
            return null;
        }
        catch (Throwable t) {
            logger.error("Cannot register shutdown hook that cleanly terminates the BLOB service.");
            return null;
        }
    }
}

