/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskmanager;

import java.io.IOException;
import java.io.Serializable;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import org.apache.flink.util.StringUtils;

public class TaskOperationResult
implements IOReadableWritable,
Serializable {
    private static final long serialVersionUID = -3852292420229699888L;
    private ExecutionAttemptID executionId;
    private boolean success;
    private String description;

    public TaskOperationResult() {
        this(new ExecutionAttemptID(), false);
    }

    public TaskOperationResult(ExecutionAttemptID executionId, boolean success) {
        this(executionId, success, null);
    }

    public TaskOperationResult(ExecutionAttemptID executionId, boolean success, String description) {
        Preconditions.checkNotNull((Object)executionId);
        this.executionId = executionId;
        this.success = success;
        this.description = description;
    }

    public ExecutionAttemptID getExecutionId() {
        return this.executionId;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getDescription() {
        return this.description;
    }

    public void read(DataInputView in) throws IOException {
        this.executionId.read(in);
        this.success = in.readBoolean();
        this.description = StringUtils.readNullableString((DataInputView)in);
    }

    public void write(DataOutputView out) throws IOException {
        this.executionId.write(out);
        out.writeBoolean(this.success);
        StringUtils.writeNullableString((String)this.description, (DataOutputView)out);
    }

    public String toString() {
        return String.format("TaskOperationResult %s [%s]%s", this.executionId, this.success ? "SUCCESS" : "FAILED", this.description == null ? "" : " - " + this.description);
    }
}

