/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.profiling.types;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.jobgraph.JobID;
import org.apache.flink.runtime.profiling.types.InstanceProfilingEvent;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import org.apache.flink.types.StringValue;

public final class SingleInstanceProfilingEvent
extends InstanceProfilingEvent {
    private static final long serialVersionUID = 1L;
    private String instanceName;

    public SingleInstanceProfilingEvent(int profilingInterval, int ioWaitCPU, int idleCPU, int userCPU, int systemCPU, int hardIrqCPU, int softIrqCPU, long totalMemory, long freeMemory, long bufferedMemory, long cachedMemory, long cachedSwapMemory, long receivedBytes, long transmittedBytes, JobID jobID, long timestamp, long profilingTimestamp, String instanceName) {
        super(profilingInterval, ioWaitCPU, idleCPU, userCPU, systemCPU, hardIrqCPU, softIrqCPU, totalMemory, freeMemory, bufferedMemory, cachedMemory, cachedSwapMemory, receivedBytes, transmittedBytes, jobID, timestamp, profilingTimestamp);
        Preconditions.checkNotNull((Object)instanceName);
        this.instanceName = instanceName;
    }

    public SingleInstanceProfilingEvent() {
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    @Override
    public void read(DataInputView in) throws IOException {
        super.read(in);
        this.instanceName = StringValue.readString((DataInput)in);
    }

    @Override
    public void write(DataOutputView out) throws IOException {
        super.write(out);
        StringValue.writeString((CharSequence)this.instanceName, (DataOutput)out);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof SingleInstanceProfilingEvent) {
            SingleInstanceProfilingEvent other = (SingleInstanceProfilingEvent)obj;
            return super.equals(obj) && this.instanceName.equals(other.instanceName);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 31 * this.instanceName.hashCode();
    }
}

