/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

public class IntArrayList {
    private int size = 0;
    private int[] array;

    public IntArrayList(int capacity) {
        this.array = new int[capacity];
    }

    public int size() {
        return this.size;
    }

    public boolean add(int number) {
        this.grow(this.size + 1);
        this.array[this.size++] = number;
        return true;
    }

    public int removeInt(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        int old = this.array[index];
        --this.size;
        if (index != this.size) {
            System.arraycopy(this.array, index + 1, this.array, index, this.size - index);
        }
        return old;
    }

    public void clear() {
        this.size = 0;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    private void grow(int length) {
        if (length > this.array.length) {
            int newLength = (int)Math.max(Math.min(2L * (long)this.array.length, 0x7FFFFFF7L), (long)length);
            int[] t = new int[newLength];
            System.arraycopy(this.array, 0, t, 0, this.size);
            this.array = t;
        }
    }
}

