/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.chaining;

import org.apache.flink.api.common.functions.Function;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.operators.RegularPactTask;
import org.apache.flink.runtime.operators.util.DistributedRuntimeUDFContext;
import org.apache.flink.runtime.operators.util.TaskConfig;
import org.apache.flink.util.Collector;

public abstract class ChainedDriver<IT, OT>
implements Collector<IT> {
    protected TaskConfig config;
    protected String taskName;
    protected Collector<OT> outputCollector;
    protected ClassLoader userCodeClassLoader;
    private DistributedRuntimeUDFContext udfContext;

    public void setup(TaskConfig config, String taskName, Collector<OT> outputCollector, AbstractInvokable parent, ClassLoader userCodeClassLoader) {
        this.config = config;
        this.taskName = taskName;
        this.outputCollector = outputCollector;
        this.userCodeClassLoader = userCodeClassLoader;
        if (parent instanceof RegularPactTask) {
            this.udfContext = ((RegularPactTask)parent).createRuntimeContext(taskName);
        } else {
            Environment env = parent.getEnvironment();
            this.udfContext = new DistributedRuntimeUDFContext(taskName, env.getCurrentNumberOfSubtasks(), env.getIndexInSubtaskGroup(), userCodeClassLoader, env.getCopyTask());
        }
        this.setup(parent);
    }

    public abstract void setup(AbstractInvokable var1);

    public abstract void openTask() throws Exception;

    public abstract void closeTask() throws Exception;

    public abstract void cancelTask();

    public abstract Function getStub();

    public abstract String getTaskName();

    public abstract void collect(IT var1);

    protected RuntimeContext getUdfRuntimeContext() {
        return this.udfContext;
    }

    public void setOutputCollector(Collector<?> outputCollector) {
        this.outputCollector = outputCollector;
    }

    public Collector<OT> getOutputCollector() {
        return this.outputCollector;
    }

    public TaskConfig getTaskConfig() {
        return this.config;
    }
}

