/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskmanager;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.jobgraph.JobID;

public class TaskExecutionState
implements IOReadableWritable,
Serializable {
    private static final long serialVersionUID = 1L;
    private JobID jobID;
    private ExecutionAttemptID executionId;
    private ExecutionState executionState;
    private Throwable error;

    public TaskExecutionState(JobID jobID, ExecutionAttemptID executionId, ExecutionState executionState) {
        this(jobID, executionId, executionState, null);
    }

    public TaskExecutionState(JobID jobID, ExecutionAttemptID executionId, ExecutionState executionState, Throwable error) {
        if (jobID == null || executionId == null || executionState == null) {
            throw new NullPointerException();
        }
        this.jobID = jobID;
        this.executionId = executionId;
        this.executionState = executionState;
        this.error = error;
    }

    public TaskExecutionState() {
        this.jobID = new JobID();
        this.executionId = new ExecutionAttemptID();
    }

    public Throwable getError() {
        return this.error;
    }

    public ExecutionAttemptID getID() {
        return this.executionId;
    }

    public ExecutionState getExecutionState() {
        return this.executionState;
    }

    public JobID getJobID() {
        return this.jobID;
    }

    public void read(DataInputView in) throws IOException {
        this.jobID.read(in);
        this.executionId.read(in);
        this.executionState = ExecutionState.values()[in.readInt()];
        int errorDataLen = in.readInt();
        if (errorDataLen > 0) {
            byte[] data = new byte[errorDataLen];
            in.readFully(data);
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(data);
                ObjectInputStream ois = new ObjectInputStream(bis);
                this.error = (Throwable)ois.readObject();
                ois.close();
            }
            catch (Throwable t) {
                this.error = new Exception("An error occurred, but the exception could not be transfered through the RPC");
            }
        } else {
            this.error = null;
        }
    }

    public void write(DataOutputView out) throws IOException {
        this.jobID.write(out);
        this.executionId.write(out);
        out.writeInt(this.executionState.ordinal());
        if (this.error != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this.error);
            oos.flush();
            oos.close();
            byte[] data = baos.toByteArray();
            out.writeInt(data.length);
            out.write(data);
        } else {
            out.writeInt(0);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof TaskExecutionState) {
            TaskExecutionState other = (TaskExecutionState)obj;
            return other.jobID.equals(this.jobID) && other.executionId.equals(this.executionId) && other.executionState == this.executionState && (other.error == null ? this.error == null : this.error != null && other.error.getClass() == this.error.getClass());
        }
        return false;
    }

    public int hashCode() {
        return this.jobID.hashCode() + this.executionId.hashCode() + this.executionState.ordinal();
    }

    public String toString() {
        return String.format("TaskState jobId=%s, executionId=%s, state=%s, error=%s", new Object[]{this.jobID, this.executionId, this.executionState, this.error == null ? "(null)" : this.error.getClass().getName() + ": " + this.error.getMessage()});
    }
}

