/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Properties;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvironmentInformation {
    private static final Logger LOG = LoggerFactory.getLogger(EnvironmentInformation.class);
    private static final String UNKNOWN = "<unknown>";
    private static final String[] IGNORED_STARTUP_OPTIONS = new String[]{"-Dlog.file", "-Dlogback.configurationFile", "-Dlog4j.configuration"};

    public static String getVersion() {
        String version = EnvironmentInformation.class.getPackage().getImplementationVersion();
        return version != null ? version : UNKNOWN;
    }

    public static RevisionInformation getRevisionInformation() {
        RevisionInformation info = new RevisionInformation();
        String revision = UNKNOWN;
        String commitDate = UNKNOWN;
        try {
            Properties properties = new Properties();
            InputStream propFile = EnvironmentInformation.class.getClassLoader().getResourceAsStream(".version.properties");
            if (propFile != null) {
                properties.load(propFile);
                revision = properties.getProperty("git.commit.id.abbrev");
                commitDate = properties.getProperty("git.commit.time");
            }
        }
        catch (Throwable t) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cannot determine code revision: Unable ro read version property file.", t);
            }
            LOG.info("Cannot determine code revision: Unable ro read version property file.");
        }
        info.commitId = revision;
        info.commitDate = commitDate;
        return info;
    }

    public static String getUserRunning() {
        try {
            return UserGroupInformation.getCurrentUser().getShortUserName();
        }
        catch (Throwable t) {
            String user;
            if (LOG.isDebugEnabled() && !(t instanceof ClassNotFoundException)) {
                LOG.debug("Cannot determine user/group information using Hadoop utils.", t);
            }
            if ((user = System.getProperty("user.name")) == null) {
                user = UNKNOWN;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Cannot determine user/group information for the current user.");
                }
            }
            return user;
        }
    }

    public static long getMaxJvmHeapMemory() {
        return Runtime.getRuntime().maxMemory();
    }

    public static long getSizeOfFreeHeapMemoryWithDefrag() {
        System.gc();
        return EnvironmentInformation.getSizeOfFreeHeapMemory();
    }

    public static long getSizeOfFreeHeapMemory() {
        Runtime r = Runtime.getRuntime();
        return r.maxMemory() - r.totalMemory() + r.freeMemory();
    }

    public static String getJvmVersion() {
        try {
            RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
            return bean.getVmName() + " - " + bean.getVmVendor() + " - " + bean.getSpecVersion() + '/' + bean.getVmVersion();
        }
        catch (Throwable t) {
            return UNKNOWN;
        }
    }

    public static String getJvmStartupOptions() {
        try {
            RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
            StringBuilder bld = new StringBuilder();
            for (String s : bean.getInputArguments()) {
                boolean append = true;
                for (String ignored : IGNORED_STARTUP_OPTIONS) {
                    if (!s.startsWith(ignored)) continue;
                    append = false;
                    break;
                }
                if (!append) continue;
                bld.append(s).append(' ');
            }
            return bld.toString();
        }
        catch (Throwable t) {
            return UNKNOWN;
        }
    }

    public static void logEnvironmentInfo(Logger log, String componentName) {
        if (log.isInfoEnabled()) {
            RevisionInformation rev = EnvironmentInformation.getRevisionInformation();
            String version = EnvironmentInformation.getVersion();
            String user = EnvironmentInformation.getUserRunning();
            String jvmVersion = EnvironmentInformation.getJvmVersion();
            String options = EnvironmentInformation.getJvmStartupOptions();
            String javaHome = System.getenv("JAVA_HOME");
            long maxHeapMegabytes = EnvironmentInformation.getMaxJvmHeapMemory() >>> 20;
            log.info("-------------------------------------------------------");
            log.info(" Starting " + componentName + " (Version: " + version + ", " + "Rev:" + rev.commitId + ", " + "Date:" + rev.commitDate + ")");
            log.info(" Current user: " + user);
            log.info(" JVM: " + jvmVersion);
            log.info(" Startup Options: " + options);
            log.info(" Maximum heap size: " + maxHeapMegabytes + " MiBytes");
            log.info(" JAVA_HOME: " + (javaHome == null ? "not set" : javaHome));
            log.info("-------------------------------------------------------");
        }
    }

    private EnvironmentInformation() {
    }

    public static void main(String[] args) {
        EnvironmentInformation.logEnvironmentInfo(LOG, "Test");
    }

    public static class RevisionInformation {
        public String commitId;
        public String commitDate;
    }
}

