/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager.scheduler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.flink.runtime.AbstractID;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.instance.AllocatedSlot;
import org.apache.flink.runtime.instance.Instance;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationConstraint;
import org.apache.flink.runtime.jobmanager.scheduler.Locality;
import org.apache.flink.runtime.jobmanager.scheduler.Scheduler;
import org.apache.flink.runtime.jobmanager.scheduler.SharedSlot;
import org.apache.flink.runtime.jobmanager.scheduler.SubSlot;
import org.slf4j.Logger;

public class SlotSharingGroupAssignment {
    private static final Logger LOG = Scheduler.LOG;
    private final Object lock = new Object();
    private final Set<SharedSlot> allSlots = new LinkedHashSet<SharedSlot>();
    private final Map<AbstractID, Map<Instance, List<SharedSlot>>> availableSlotsPerJid = new LinkedHashMap<AbstractID, Map<Instance, List<SharedSlot>>>();

    public SubSlot addNewSlotWithTask(AllocatedSlot slot, ExecutionVertex vertex) {
        JobVertexID id = vertex.getJobvertexId();
        return this.addNewSlotWithTask(slot, id, id);
    }

    public SubSlot addNewSlotWithTask(AllocatedSlot slot, ExecutionVertex vertex, CoLocationConstraint constraint) {
        AbstractID groupId = constraint.getGroupId();
        return this.addNewSlotWithTask(slot, groupId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SubSlot addNewSlotWithTask(AllocatedSlot slot, AbstractID groupId, JobVertexID vertexId) {
        SharedSlot sharedSlot = new SharedSlot(slot, this);
        Instance location = slot.getInstance();
        Object object = this.lock;
        synchronized (object) {
            this.allSlots.add(sharedSlot);
            SubSlot subslot = sharedSlot.allocateSubSlot(vertexId);
            subslot.setLocality(slot.getLocality());
            boolean entryForNewJidExists = false;
            for (Map.Entry<AbstractID, Map<Instance, List<SharedSlot>>> entry : this.availableSlotsPerJid.entrySet()) {
                if (entry.getKey().equals(groupId)) {
                    entryForNewJidExists = true;
                    continue;
                }
                Map<Instance, List<SharedSlot>> available = entry.getValue();
                SlotSharingGroupAssignment.putIntoMultiMap(available, location, sharedSlot);
            }
            if (!entryForNewJidExists) {
                this.availableSlotsPerJid.put(groupId, new LinkedHashMap());
            }
            return subslot;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubSlot getSlotForTask(ExecutionVertex vertex) {
        Object object = this.lock;
        synchronized (object) {
            Pair<SharedSlot, Locality> p = this.getSlotForTaskInternal(vertex.getJobvertexId(), vertex, vertex.getPreferredLocations(), false);
            if (p != null) {
                SharedSlot ss = (SharedSlot)p.getLeft();
                SubSlot slot = ss.allocateSubSlot(vertex.getJobvertexId());
                slot.setLocality((Locality)((Object)p.getRight()));
                return slot;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubSlot getSlotForTask(ExecutionVertex vertex, CoLocationConstraint constraint) {
        Object object = this.lock;
        synchronized (object) {
            SharedSlot shared = constraint.getSharedSlot();
            if (shared != null && !shared.isDisposed()) {
                SubSlot subslot = shared.allocateSubSlot(null);
                subslot.setLocality(Locality.LOCAL);
                return subslot;
            }
            if (shared == null) {
                Pair<SharedSlot, Locality> p = this.getSlotForTaskInternal(constraint.getGroupId(), vertex, vertex.getPreferredLocations(), false);
                if (p == null) {
                    return null;
                }
                shared = (SharedSlot)p.getLeft();
                Locality l = (Locality)((Object)p.getRight());
                SubSlot sub = shared.allocateSubSlot(null);
                sub.setLocality(l);
                if (l != Locality.NON_LOCAL) {
                    constraint.setSharedSlot(shared);
                }
                return sub;
            }
            Instance location = shared.getAllocatedSlot().getInstance();
            Pair<SharedSlot, Locality> p = this.getSlotForTaskInternal(constraint.getGroupId(), vertex, Collections.singleton(location), true);
            if (p == null) {
                return null;
            }
            shared = (SharedSlot)p.getLeft();
            constraint.setSharedSlot(shared);
            SubSlot subslot = shared.allocateSubSlot(null);
            subslot.setLocality(Locality.LOCAL);
            return subslot;
        }
    }

    private Pair<SharedSlot, Locality> getSlotForTaskInternal(AbstractID groupId, ExecutionVertex vertex, Iterable<Instance> preferredLocations, boolean localOnly) {
        if (this.allSlots.isEmpty()) {
            return null;
        }
        Map<Instance, List<SharedSlot>> slotsForGroup = this.availableSlotsPerJid.get(groupId);
        if (slotsForGroup == null) {
            slotsForGroup = new LinkedHashMap<Instance, List<SharedSlot>>();
            this.availableSlotsPerJid.put(groupId, slotsForGroup);
            for (SharedSlot sharedSlot : this.allSlots) {
                SlotSharingGroupAssignment.putIntoMultiMap(slotsForGroup, sharedSlot.getAllocatedSlot().getInstance(), sharedSlot);
            }
        } else if (slotsForGroup.isEmpty()) {
            return null;
        }
        boolean didNotGetPreferred = false;
        if (preferredLocations != null) {
            for (Instance location : preferredLocations) {
                didNotGetPreferred = true;
                SharedSlot slot = SlotSharingGroupAssignment.removeFromMultiMap(slotsForGroup, location);
                if (slot == null || slot.isDisposed()) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Local assignment in shared group : " + vertex + " --> " + slot);
                }
                return new ImmutablePair((Object)slot, (Object)Locality.LOCAL);
            }
        }
        if (didNotGetPreferred && localOnly) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No local assignment in shared possible for " + vertex);
            }
            return null;
        }
        SharedSlot sharedSlot = SlotSharingGroupAssignment.pollFromMultiMap(slotsForGroup);
        if (sharedSlot != null && !sharedSlot.isDisposed()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((didNotGetPreferred ? "Non-local" : "Unconstrained") + " assignment in shared group : " + vertex + " --> " + sharedSlot);
            }
            return new ImmutablePair((Object)sharedSlot, (Object)(didNotGetPreferred ? Locality.NON_LOCAL : Locality.UNCONSTRAINED));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void releaseSubSlot(SubSlot subslot, SharedSlot sharedSlot) {
        AbstractID groupId = subslot.getGroupId();
        Object object = this.lock;
        synchronized (object) {
            if (!this.allSlots.contains(sharedSlot)) {
                throw new IllegalArgumentException("Slot was not associated with this SlotSharingGroup before.");
            }
            int slotsRemaining = sharedSlot.releaseSlot(subslot);
            if (slotsRemaining == 0) {
                try {
                    this.allSlots.remove(sharedSlot);
                    Instance location = sharedSlot.getAllocatedSlot().getInstance();
                    if (groupId == null) return;
                    for (Map.Entry<AbstractID, Map<Instance, List<SharedSlot>>> mapEntry : this.availableSlotsPerJid.entrySet()) {
                        AbstractID id = mapEntry.getKey();
                        if (id.getClass() == AbstractID.class || id.equals(groupId)) continue;
                        Map<Instance, List<SharedSlot>> map = mapEntry.getValue();
                        List<SharedSlot> list = map.get(location);
                        if (list == null || !list.remove(sharedSlot)) {
                            throw new IllegalStateException("Bug: SharedSlot was not available to another vertex type that it was not allocated for before.");
                        }
                        if (!list.isEmpty()) continue;
                        map.remove(location);
                    }
                }
                finally {
                    sharedSlot.dispose();
                }
            } else {
                if (groupId == null) return;
                Map<Instance, List<SharedSlot>> slotsForJid = this.availableSlotsPerJid.get(groupId);
                if (slotsForJid == null) {
                    throw new IllegalStateException("Trying to return a slot for group " + groupId + " when available slots indicated that all slots were available.");
                }
                SlotSharingGroupAssignment.putIntoMultiMap(slotsForJid, sharedSlot.getAllocatedSlot().getInstance(), sharedSlot);
            }
            return;
        }
    }

    public int getNumberOfSlots() {
        return this.allSlots.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfAvailableSlotsForJid(JobVertexID jid) {
        Object object = this.lock;
        synchronized (object) {
            Map<Instance, List<SharedSlot>> available = this.availableSlotsPerJid.get(jid);
            if (available != null) {
                HashSet<SharedSlot> set = new HashSet<SharedSlot>();
                for (List<SharedSlot> list : available.values()) {
                    for (SharedSlot slot : list) {
                        set.add(slot);
                    }
                }
                return set.size();
            }
            return this.allSlots.size();
        }
    }

    private static final void putIntoMultiMap(Map<Instance, List<SharedSlot>> map, Instance location, SharedSlot slot) {
        List<SharedSlot> slotsForInstance = map.get(location);
        if (slotsForInstance == null) {
            slotsForInstance = new ArrayList<SharedSlot>();
            map.put(location, slotsForInstance);
        }
        slotsForInstance.add(slot);
    }

    private static final SharedSlot removeFromMultiMap(Map<Instance, List<SharedSlot>> map, Instance location) {
        List<SharedSlot> slotsForLocation = map.get(location);
        if (slotsForLocation == null) {
            return null;
        }
        SharedSlot slot = slotsForLocation.remove(slotsForLocation.size() - 1);
        if (slotsForLocation.isEmpty()) {
            map.remove(location);
        }
        return slot;
    }

    private static final SharedSlot pollFromMultiMap(Map<Instance, List<SharedSlot>> map) {
        Iterator<Map.Entry<Instance, List<SharedSlot>>> iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            List<SharedSlot> slots = iter.next().getValue();
            if (slots.isEmpty()) {
                iter.remove();
                continue;
            }
            if (slots.size() == 1) {
                SharedSlot slot = slots.remove(0);
                iter.remove();
                return slot;
            }
            return slots.remove(slots.size() - 1);
        }
        return null;
    }
}

