/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.executiongraph.IntermediateResultPartition;
import org.apache.flink.runtime.io.network.channels.ChannelID;

public class ExecutionEdge {
    private final IntermediateResultPartition source;
    private final ExecutionVertex target;
    private final int inputNum;
    private final ChannelID inputChannelId;
    private final ChannelID outputChannelId;

    public ExecutionEdge(IntermediateResultPartition source, ExecutionVertex target, int inputNum) {
        this.source = source;
        this.target = target;
        this.inputNum = inputNum;
        this.inputChannelId = new ChannelID();
        this.outputChannelId = new ChannelID();
    }

    public ExecutionEdge(IntermediateResultPartition source, ExecutionVertex target, int inputNum, ChannelID inputChannelId, ChannelID outputChannelId) {
        this.source = source;
        this.target = target;
        this.inputNum = inputNum;
        this.inputChannelId = inputChannelId;
        this.outputChannelId = outputChannelId;
    }

    public IntermediateResultPartition getSource() {
        return this.source;
    }

    public ExecutionVertex getTarget() {
        return this.target;
    }

    public int getInputNum() {
        return this.inputNum;
    }

    public ChannelID getInputChannelId() {
        return this.inputChannelId;
    }

    public ChannelID getOutputChannelId() {
        return this.outputChannelId;
    }
}

