/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.execution.librarycache;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.BlobService;
import org.apache.flink.runtime.execution.librarycache.LibraryCacheManager;
import org.apache.flink.runtime.jobgraph.JobID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BlobLibraryCacheManager
extends TimerTask
implements LibraryCacheManager {
    private static Logger LOG = LoggerFactory.getLogger(BlobLibraryCacheManager.class);
    private final Object lockObject = new Object();
    private final ConcurrentMap<JobID, URLClassLoader> classLoaders = new ConcurrentHashMap<JobID, URLClassLoader>();
    private final Map<JobID, Integer> libraryReferenceCounter = new HashMap<JobID, Integer>();
    private final Map<JobID, Collection<BlobKey>> requiredJars = new HashMap<JobID, Collection<BlobKey>>();
    private final Map<BlobKey, Integer> blobKeyReferenceCounter = new HashMap<BlobKey, Integer>();
    private final Set<BlobKey> registeredBlobs = new HashSet<BlobKey>();
    private final BlobService blobService;

    public BlobLibraryCacheManager(BlobService blobService, Configuration configuration) {
        this.blobService = blobService;
        Timer timer = new Timer(true);
        long cleanupInterval = configuration.getLong("library-cache-manager.cleanup.interval", 3600L) * 1000L;
        timer.schedule((TimerTask)this, cleanupInterval);
    }

    private <K> int incrementReferenceCounter(K key, Map<K, Integer> map) {
        if (!map.containsKey(key)) {
            map.put(key, 1);
            return 1;
        }
        int counter = map.get(key) + 1;
        map.put(key, counter);
        return counter;
    }

    private <K> int decrementReferenceCounter(K key, Map<K, Integer> map) {
        if (!map.containsKey(key)) {
            throw new IllegalStateException("Cannot find reference counter entry for key " + key);
        }
        int counter = map.get(key) - 1;
        if (counter == 0) {
            map.remove(key);
        } else {
            map.put(key, counter);
        }
        return counter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(JobID id, Collection<BlobKey> requiredJarFiles) throws IOException {
        Object object = this.lockObject;
        synchronized (object) {
            if (this.incrementReferenceCounter(id, this.libraryReferenceCounter) > 1) {
                return;
            }
            if (this.classLoaders.containsKey(id)) {
                throw new IllegalStateException("Library cache manager already contains class loader entry for job ID " + id);
            }
            if (this.requiredJars.containsKey(id)) {
                throw new IllegalStateException("Library cache manager already contains blob keys entry for job ID " + id);
            }
            this.requiredJars.put(id, requiredJarFiles);
            URL[] urls = new URL[requiredJarFiles.size()];
            int count = 0;
            for (BlobKey blobKey : requiredJarFiles) {
                urls[count++] = this.registerBlobKeyAndGetURL(blobKey);
            }
            URLClassLoader classLoader = new URLClassLoader(urls);
            this.classLoaders.put(id, classLoader);
        }
    }

    private URL registerBlobKeyAndGetURL(BlobKey key) throws IOException {
        if (this.incrementReferenceCounter(key, this.blobKeyReferenceCounter) == 1) {
            this.registeredBlobs.add(key);
        }
        return this.blobService.getURL(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(JobID id) {
        Object object = this.lockObject;
        synchronized (object) {
            if (this.decrementReferenceCounter(id, this.libraryReferenceCounter) == 0) {
                this.classLoaders.remove(id);
                Collection<BlobKey> keys = this.requiredJars.get(id);
                for (BlobKey key : keys) {
                    this.decrementReferenceCounter(key, this.blobKeyReferenceCounter);
                }
                this.requiredJars.remove(id);
            }
        }
    }

    @Override
    public ClassLoader getClassLoader(JobID id) {
        return (ClassLoader)this.classLoaders.get(id);
    }

    @Override
    public File getFile(BlobKey blobKey) throws IOException {
        return new File(this.blobService.getURL(blobKey).getFile());
    }

    public int getBlobServerPort() {
        return this.blobService.getPort();
    }

    @Override
    public void shutdown() throws IOException {
        this.blobService.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.lockObject;
        synchronized (object) {
            Iterator<BlobKey> it = this.registeredBlobs.iterator();
            while (it.hasNext()) {
                BlobKey key = it.next();
                try {
                    if (this.blobKeyReferenceCounter.containsKey(key)) continue;
                    this.blobService.delete(key);
                    it.remove();
                }
                catch (IOException ioe) {
                    LOG.warn("Could not delete file with blob key" + key, (Throwable)ioe);
                }
            }
        }
    }
}

