/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.chaining;

import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.Function;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.operators.RegularPactTask;
import org.apache.flink.runtime.operators.chaining.ChainedDriver;
import org.apache.flink.runtime.operators.chaining.ExceptionInChainedStubException;

public class ChainedFlatMapDriver<IT, OT>
extends ChainedDriver<IT, OT> {
    private FlatMapFunction<IT, OT> mapper;

    @Override
    public void setup(AbstractInvokable parent) {
        FlatMapFunction mapper;
        this.mapper = mapper = RegularPactTask.instantiateUserCode(this.config, this.userCodeClassLoader, FlatMapFunction.class);
        FunctionUtils.setFunctionRuntimeContext((Function)mapper, (RuntimeContext)this.getUdfRuntimeContext());
    }

    @Override
    public void openTask() throws Exception {
        Configuration stubConfig = this.config.getStubParameters();
        RegularPactTask.openUserCode(this.mapper, stubConfig);
    }

    @Override
    public void closeTask() throws Exception {
        RegularPactTask.closeUserCode(this.mapper);
    }

    @Override
    public void cancelTask() {
        try {
            FunctionUtils.closeFunction(this.mapper);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public Function getStub() {
        return this.mapper;
    }

    @Override
    public String getTaskName() {
        return this.taskName;
    }

    @Override
    public void collect(IT record) {
        try {
            this.mapper.flatMap(record, this.outputCollector);
        }
        catch (Exception ex) {
            throw new ExceptionInChainedStubException(this.taskName, ex);
        }
    }

    public void close() {
        this.outputCollector.close();
    }
}

