/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph;

import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.operators.util.UserCodeWrapper;
import org.apache.flink.core.io.InputSplitSource;
import org.apache.flink.runtime.jobgraph.AbstractJobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.operators.util.TaskConfig;

public class InputFormatVertex
extends AbstractJobVertex {
    private static final long serialVersionUID = 1L;
    private transient InputFormat<?, ?> inputFormat;

    public InputFormatVertex(String name) {
        super(name);
    }

    public InputFormatVertex(String name, JobVertexID id) {
        super(name, id);
    }

    @Override
    public void initializeOnMaster(ClassLoader loader) throws Exception {
        if (this.inputFormat == null) {
            TaskConfig cfg = new TaskConfig(this.getConfiguration());
            UserCodeWrapper wrapper = cfg.getStubWrapper(loader);
            if (wrapper == null) {
                throw new Exception("No input format present in InputFormatVertex's task configuration.");
            }
            this.inputFormat = (InputFormat)wrapper.getUserCodeObject(InputFormat.class, loader);
            this.inputFormat.configure(cfg.getStubParameters());
        }
        this.setInputSplitSource((InputSplitSource<?>)this.inputFormat);
    }
}

