/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.gates;

import java.io.IOException;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.runtime.event.task.AbstractEvent;
import org.apache.flink.runtime.event.task.AbstractTaskEvent;
import org.apache.flink.runtime.event.task.EventListener;
import org.apache.flink.runtime.event.task.EventNotificationManager;
import org.apache.flink.runtime.io.network.channels.ChannelType;
import org.apache.flink.runtime.io.network.gates.GateID;
import org.apache.flink.runtime.jobgraph.JobID;

public abstract class Gate<T extends IOReadableWritable> {
    private final JobID jobID;
    private final GateID gateID;
    private final int index;
    private final EventNotificationManager eventNotificationManager = new EventNotificationManager();
    private ChannelType channelType = ChannelType.NETWORK;

    protected Gate(JobID jobID, GateID gateID, int index) {
        this.jobID = jobID;
        this.gateID = gateID;
        this.index = index;
    }

    public final int getIndex() {
        return this.index;
    }

    protected final EventNotificationManager getEventNotificationManager() {
        return this.eventNotificationManager;
    }

    public String toString() {
        return "Gate " + this.index;
    }

    public final void subscribeToEvent(EventListener eventListener, Class<? extends AbstractTaskEvent> eventType) {
        this.eventNotificationManager.subscribeToEvent(eventListener, eventType);
    }

    public final void unsubscribeFromEvent(EventListener eventListener, Class<? extends AbstractTaskEvent> eventType) {
        this.eventNotificationManager.unsubscribeFromEvent(eventListener, eventType);
    }

    public final void deliverEvent(AbstractTaskEvent event) {
        this.eventNotificationManager.deliverEvent(event);
    }

    public final void setChannelType(ChannelType channelType) {
        this.channelType = channelType;
    }

    public final ChannelType getChannelType() {
        return this.channelType;
    }

    public JobID getJobID() {
        return this.jobID;
    }

    public GateID getGateID() {
        return this.gateID;
    }

    public abstract void publishEvent(AbstractEvent var1) throws IOException, InterruptedException;

    public abstract void releaseAllChannelResources();

    public abstract boolean isClosed() throws IOException, InterruptedException;

    public abstract boolean isInputGate();
}

