/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.sort;

import java.util.AbstractQueue;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Queue;

public class PartialOrderPriorityQueue<T>
extends AbstractQueue<T>
implements Queue<T> {
    private final T[] heap;
    private final Comparator<T> comparator;
    private final int capacity;
    private int size;

    public PartialOrderPriorityQueue(Comparator<T> comparator, int capacity) {
        this.comparator = comparator;
        this.capacity = capacity + 1;
        this.size = 0;
        this.heap = new Object[this.capacity];
    }

    private final boolean lessThan(T a, T b) {
        return this.comparator.compare(a, b) < 0;
    }

    public int remainingCapacity() {
        return this.capacity - this.size;
    }

    public final void put(T element) {
        ++this.size;
        this.heap[this.size] = element;
        this.upHeap();
    }

    @Override
    public boolean offer(T element) {
        if (this.size < this.capacity) {
            this.put(element);
            return true;
        }
        if (this.size > 0 && !this.lessThan(element, this.peek())) {
            this.heap[1] = element;
            this.adjustTop();
            return true;
        }
        return false;
    }

    @Override
    public final T peek() {
        if (this.size > 0) {
            return this.heap[1];
        }
        return null;
    }

    @Override
    public final T poll() {
        if (this.size > 0) {
            T result = this.heap[1];
            this.heap[1] = this.heap[this.size];
            this.heap[this.size] = null;
            --this.size;
            this.downHeap();
            return result;
        }
        return null;
    }

    public final void adjustTop() {
        this.downHeap();
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final void clear() {
        for (int i = 0; i <= this.size; ++i) {
            this.heap[i] = null;
        }
        this.size = 0;
    }

    private final void upHeap() {
        int i = this.size;
        T node = this.heap[i];
        for (int j = i >>> 1; j > 0 && this.lessThan(node, this.heap[j]); j >>>= 1) {
            this.heap[i] = this.heap[j];
            i = j;
        }
        this.heap[i] = node;
    }

    private final void downHeap() {
        int i = 1;
        T node = this.heap[i];
        int j = i << 1;
        int k = j + 1;
        if (k <= this.size && this.lessThan(this.heap[k], this.heap[j])) {
            j = k;
        }
        while (j <= this.size && this.lessThan(this.heap[j], node)) {
            this.heap[i] = this.heap[j];
            i = j;
            k = (j = i << 1) + 1;
            if (k > this.size || !this.lessThan(this.heap[k], this.heap[j])) continue;
            j = k;
        }
        this.heap[i] = node;
    }

    @Override
    public Iterator<T> iterator() {
        return Arrays.asList(this.heap).iterator();
    }
}

