/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.chaining;

import java.io.IOException;
import java.util.List;
import org.apache.flink.api.common.functions.FlatCombineFunction;
import org.apache.flink.api.common.functions.Function;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeComparatorFactory;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerFactory;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.memorymanager.MemoryManager;
import org.apache.flink.runtime.operators.RegularPactTask;
import org.apache.flink.runtime.operators.chaining.ChainedDriver;
import org.apache.flink.runtime.operators.chaining.ExceptionInChainedStubException;
import org.apache.flink.runtime.operators.sort.FixedLengthRecordSorter;
import org.apache.flink.runtime.operators.sort.InMemorySorter;
import org.apache.flink.runtime.operators.sort.NormalizedKeySorter;
import org.apache.flink.runtime.operators.sort.QuickSort;
import org.apache.flink.runtime.util.KeyGroupedIterator;
import org.apache.flink.util.Collector;

public class SynchronousChainedCombineDriver<T>
extends ChainedDriver<T, T> {
    private static final int THRESHOLD_FOR_IN_PLACE_SORTING = 32;
    private InMemorySorter<T> sorter;
    private FlatCombineFunction<T> combiner;
    private TypeSerializer<T> serializer;
    private TypeComparator<T> comparator;
    private AbstractInvokable parent;
    private QuickSort sortAlgo = new QuickSort();
    private MemoryManager memManager;
    private volatile boolean running = true;

    @Override
    public void setup(AbstractInvokable parent) {
        FlatCombineFunction combiner;
        this.parent = parent;
        this.combiner = combiner = RegularPactTask.instantiateUserCode(this.config, this.userCodeClassLoader, FlatCombineFunction.class);
        FunctionUtils.setFunctionRuntimeContext((Function)combiner, (RuntimeContext)this.getUdfRuntimeContext());
    }

    @Override
    public void openTask() throws Exception {
        Configuration stubConfig = this.config.getStubParameters();
        RegularPactTask.openUserCode(this.combiner, stubConfig);
        this.memManager = this.parent.getEnvironment().getMemoryManager();
        int numMemoryPages = this.memManager.computeNumberOfPages(this.config.getRelativeMemoryDriver());
        TypeSerializerFactory serializerFactory = this.config.getInputSerializer(0, this.userCodeClassLoader);
        TypeComparatorFactory comparatorFactory = this.config.getDriverComparator(0, this.userCodeClassLoader);
        this.serializer = serializerFactory.getSerializer();
        this.comparator = comparatorFactory.createComparator();
        List<MemorySegment> memory = this.memManager.allocatePages(this.parent, numMemoryPages);
        this.sorter = this.comparator.supportsSerializationWithKeyNormalization() && this.serializer.getLength() > 0 && this.serializer.getLength() <= 32 ? new FixedLengthRecordSorter<T>(this.serializer, this.comparator, memory) : new NormalizedKeySorter<T>(this.serializer, this.comparator.duplicate(), memory);
    }

    @Override
    public void closeTask() throws Exception {
        this.memManager.release(this.sorter.dispose());
        if (!this.running) {
            return;
        }
        RegularPactTask.closeUserCode(this.combiner);
    }

    @Override
    public void cancelTask() {
        this.running = false;
        this.memManager.release(this.sorter.dispose());
    }

    @Override
    public Function getStub() {
        return this.combiner;
    }

    @Override
    public String getTaskName() {
        return this.taskName;
    }

    @Override
    public void collect(T record) {
        try {
            if (this.sorter.write(record)) {
                return;
            }
        }
        catch (IOException e) {
            throw new ExceptionInChainedStubException(this.taskName, e);
        }
        try {
            this.sortAndCombine();
        }
        catch (Exception e) {
            throw new ExceptionInChainedStubException(this.taskName, e);
        }
        this.sorter.reset();
        try {
            if (!this.sorter.write(record)) {
                throw new IOException("Cannot write record to fresh sort buffer. Record too large.");
            }
        }
        catch (IOException e) {
            throw new ExceptionInChainedStubException(this.taskName, e);
        }
    }

    public void close() {
        try {
            this.sortAndCombine();
        }
        catch (Exception e) {
            throw new ExceptionInChainedStubException(this.taskName, e);
        }
        this.outputCollector.close();
    }

    private void sortAndCombine() throws Exception {
        InMemorySorter<T> sorter = this.sorter;
        if (!sorter.isEmpty()) {
            this.sortAlgo.sort(sorter);
            KeyGroupedIterator<T> keyIter = new KeyGroupedIterator<T>(sorter.getIterator(), this.serializer, this.comparator);
            FlatCombineFunction<T> stub = this.combiner;
            Collector output = this.outputCollector;
            while (this.running && keyIter.nextKey()) {
                stub.combine((Iterable)keyIter.getValues(), output);
            }
        }
    }
}

