/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.operators.DriverStrategy;
import org.apache.flink.runtime.operators.PactDriver;
import org.apache.flink.runtime.operators.PactTaskContext;
import org.apache.flink.runtime.operators.util.TaskConfig;
import org.apache.flink.runtime.util.KeyGroupedIterator;
import org.apache.flink.util.Collector;
import org.apache.flink.util.MutableObjectIterator;

public class GroupReduceDriver<IT, OT>
implements PactDriver<GroupReduceFunction<IT, OT>, OT> {
    private static final Log LOG = LogFactory.getLog(GroupReduceDriver.class);
    private PactTaskContext<GroupReduceFunction<IT, OT>, OT> taskContext;
    private MutableObjectIterator<IT> input;
    private TypeSerializer<IT> serializer;
    private TypeComparator<IT> comparator;
    private volatile boolean running;

    @Override
    public void setup(PactTaskContext<GroupReduceFunction<IT, OT>, OT> context) {
        this.taskContext = context;
        this.running = true;
    }

    @Override
    public int getNumberOfInputs() {
        return 1;
    }

    @Override
    public Class<GroupReduceFunction<IT, OT>> getStubType() {
        Class<GroupReduceFunction> clazz = GroupReduceFunction.class;
        return clazz;
    }

    @Override
    public boolean requiresComparatorOnInput() {
        return true;
    }

    @Override
    public void prepare() throws Exception {
        TaskConfig config = this.taskContext.getTaskConfig();
        if (config.getDriverStrategy() != DriverStrategy.SORTED_GROUP_REDUCE) {
            throw new Exception("Unrecognized driver strategy for GroupReduce driver: " + config.getDriverStrategy().name());
        }
        this.serializer = this.taskContext.getInputSerializer(0).getSerializer();
        this.comparator = this.taskContext.getInputComparator(0);
        this.input = this.taskContext.getInput(0);
    }

    @Override
    public void run() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)this.taskContext.formatLogString("GroupReducer preprocessing done. Running GroupReducer code."));
        }
        KeyGroupedIterator<IT> iter = new KeyGroupedIterator<IT>(this.input, this.serializer, this.comparator);
        GroupReduceFunction<IT, OT> stub = this.taskContext.getStub();
        Collector<OT> output = this.taskContext.getOutputCollector();
        while (this.running && iter.nextKey()) {
            stub.reduce((Iterable)iter.getValues(), output);
        }
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void cancel() {
        this.running = false;
    }
}

