/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators;

import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypePairComparatorFactory;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.operators.MatchDriver;
import org.apache.flink.runtime.operators.ResettablePactDriver;
import org.apache.flink.runtime.operators.hash.BuildFirstReOpenableHashMatchIterator;
import org.apache.flink.runtime.operators.hash.BuildSecondReOpenableHashMatchIterator;
import org.apache.flink.runtime.operators.util.JoinTaskIterator;
import org.apache.flink.runtime.operators.util.TaskConfig;
import org.apache.flink.util.Collector;
import org.apache.flink.util.MutableObjectIterator;

public abstract class AbstractCachedBuildSideMatchDriver<IT1, IT2, OT>
extends MatchDriver<IT1, IT2, OT>
implements ResettablePactDriver<FlatJoinFunction<IT1, IT2, OT>, OT> {
    private volatile JoinTaskIterator<IT1, IT2, OT> matchIterator;
    private final int buildSideIndex;
    private final int probeSideIndex;

    protected AbstractCachedBuildSideMatchDriver(int buildSideIndex, int probeSideIndex) {
        this.buildSideIndex = buildSideIndex;
        this.probeSideIndex = probeSideIndex;
    }

    @Override
    public boolean isInputResettable(int inputNum) {
        if (inputNum < 0 || inputNum > 1) {
            throw new IndexOutOfBoundsException();
        }
        return inputNum == this.buildSideIndex;
    }

    @Override
    public void initialize() throws Exception {
        TaskConfig config = this.taskContext.getTaskConfig();
        TypeSerializer serializer1 = this.taskContext.getInputSerializer(0).getSerializer();
        TypeSerializer serializer2 = this.taskContext.getInputSerializer(1).getSerializer();
        TypeComparator comparator1 = this.taskContext.getInputComparator(0);
        TypeComparator comparator2 = this.taskContext.getInputComparator(1);
        MutableObjectIterator input1 = this.taskContext.getInput(0);
        MutableObjectIterator input2 = this.taskContext.getInput(1);
        TypePairComparatorFactory pairComparatorFactory = this.taskContext.getTaskConfig().getPairComparatorFactory(this.taskContext.getUserCodeClassLoader());
        double availableMemory = config.getRelativeMemoryDriver();
        if (this.buildSideIndex == 0 && this.probeSideIndex == 1) {
            this.matchIterator = new BuildFirstReOpenableHashMatchIterator(input1, input2, serializer1, comparator1, serializer2, comparator2, pairComparatorFactory.createComparator21(comparator1, comparator2), this.taskContext.getMemoryManager(), this.taskContext.getIOManager(), this.taskContext.getOwningNepheleTask(), availableMemory);
        } else if (this.buildSideIndex == 1 && this.probeSideIndex == 0) {
            this.matchIterator = new BuildSecondReOpenableHashMatchIterator(input1, input2, serializer1, comparator1, serializer2, comparator2, pairComparatorFactory.createComparator12(comparator1, comparator2), this.taskContext.getMemoryManager(), this.taskContext.getIOManager(), this.taskContext.getOwningNepheleTask(), availableMemory);
        } else {
            throw new Exception("Error: Inconcistent setup for repeatable hash join driver.");
        }
        this.matchIterator.open();
    }

    @Override
    public void prepare() throws Exception {
    }

    @Override
    public void run() throws Exception {
        FlatJoinFunction matchStub = (FlatJoinFunction)this.taskContext.getStub();
        Collector collector = this.taskContext.getOutputCollector();
        if (this.buildSideIndex == 0) {
            BuildFirstReOpenableHashMatchIterator matchIterator = (BuildFirstReOpenableHashMatchIterator)this.matchIterator;
            while (this.running && matchIterator != null && matchIterator.callWithNextKey(matchStub, collector)) {
            }
        } else if (this.buildSideIndex == 1) {
            BuildSecondReOpenableHashMatchIterator matchIterator = (BuildSecondReOpenableHashMatchIterator)this.matchIterator;
            while (this.running && matchIterator != null && matchIterator.callWithNextKey(matchStub, collector)) {
            }
        } else {
            throw new Exception();
        }
    }

    @Override
    public void cleanup() throws Exception {
    }

    @Override
    public void reset() throws Exception {
        MutableObjectIterator input1 = this.taskContext.getInput(0);
        MutableObjectIterator input2 = this.taskContext.getInput(1);
        if (this.buildSideIndex == 0 && this.probeSideIndex == 1) {
            BuildFirstReOpenableHashMatchIterator matchIterator = (BuildFirstReOpenableHashMatchIterator)this.matchIterator;
            matchIterator.reopenProbe(input2);
        } else {
            BuildSecondReOpenableHashMatchIterator matchIterator = (BuildSecondReOpenableHashMatchIterator)this.matchIterator;
            matchIterator.reopenProbe(input1);
        }
    }

    @Override
    public void teardown() {
        this.running = false;
        if (this.matchIterator != null) {
            this.matchIterator.close();
        }
    }

    @Override
    public void cancel() {
        this.running = false;
        if (this.matchIterator != null) {
            this.matchIterator.abort();
        }
    }
}

