/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager.splitassigner;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.core.io.StringRecord;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.execution.librarycache.LibraryCacheManager;
import org.apache.flink.runtime.jobgraph.JobID;
import org.apache.flink.util.StringUtils;

public final class InputSplitWrapper
implements IOReadableWritable {
    private JobID jobID;
    private InputSplit inputSplit = null;

    public InputSplitWrapper(JobID jobID, InputSplit inputSplit) {
        if (jobID == null) {
            throw new IllegalArgumentException("Argument jobID must not be null");
        }
        this.jobID = jobID;
        this.inputSplit = inputSplit;
    }

    public InputSplitWrapper() {
        this.jobID = new JobID();
    }

    public void write(DataOutputView out) throws IOException {
        this.jobID.write(out);
        if (this.inputSplit == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            StringRecord.writeString((DataOutput)out, (String)this.inputSplit.getClass().getName());
            this.inputSplit.write(out);
        }
    }

    public void read(DataInputView in) throws IOException {
        this.jobID.read(in);
        if (in.readBoolean()) {
            ClassLoader cl = LibraryCacheManager.getClassLoader(this.jobID);
            if (cl == null) {
                throw new IOException("Cannot find class loader for job " + this.jobID);
            }
            String className = StringRecord.readString((DataInput)in);
            Class<?> splitClass = null;
            try {
                splitClass = Class.forName(className, true, cl);
            }
            catch (ClassNotFoundException e) {
                throw new IOException(StringUtils.stringifyException((Throwable)e));
            }
            try {
                this.inputSplit = (InputSplit)splitClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new IOException(StringUtils.stringifyException((Throwable)e));
            }
            catch (IllegalAccessException e) {
                throw new IOException(StringUtils.stringifyException((Throwable)e));
            }
            this.inputSplit.read(in);
        } else {
            this.inputSplit = null;
        }
    }

    public InputSplit getInputSplit() {
        return this.inputSplit;
    }
}

