/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.execution.librarycache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.execution.librarycache.LibraryCacheManager;

public class LibraryCacheUpdate
implements IOReadableWritable {
    private String libraryFileName = null;

    public LibraryCacheUpdate(String libraryFileName) {
        this.libraryFileName = libraryFileName;
    }

    public LibraryCacheUpdate() {
    }

    public void read(DataInputView in) throws IOException {
        LibraryCacheManager.readLibraryFromStream((DataInput)in);
    }

    public void write(DataOutputView out) throws IOException {
        if (this.libraryFileName == null) {
            throw new IOException("libraryFileName is null");
        }
        LibraryCacheManager.writeLibraryToStream(this.libraryFileName, (DataOutput)out);
    }
}

