/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.execution.librarycache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.io.StringRecord;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.execution.librarycache.LibraryCacheProfileRequest;

public class LibraryCacheProfileResponse
implements IOReadableWritable {
    private String[] requiredLibraries = null;
    private boolean[] cached = null;

    public LibraryCacheProfileResponse(LibraryCacheProfileRequest request) {
        this.requiredLibraries = request.getRequiredLibraries();
        this.cached = new boolean[this.requiredLibraries.length];
    }

    public LibraryCacheProfileResponse() {
    }

    public void setCached(int pos, boolean cached) {
        if (pos < this.cached.length) {
            this.cached[pos] = cached;
        }
    }

    public boolean isCached(int pos) {
        if (pos < this.cached.length) {
            return this.cached[pos];
        }
        return false;
    }

    public void read(DataInputView in) throws IOException {
        int i;
        this.requiredLibraries = new String[in.readInt()];
        for (i = 0; i < this.requiredLibraries.length; ++i) {
            this.requiredLibraries[i] = StringRecord.readString((DataInput)in);
        }
        this.cached = new boolean[in.readInt()];
        for (i = 0; i < this.cached.length; ++i) {
            this.cached[i] = in.readBoolean();
        }
    }

    public void write(DataOutputView out) throws IOException {
        int i;
        if (this.requiredLibraries == null) {
            throw new IOException("requiredLibraries is null");
        }
        if (this.cached == null) {
            throw new IOException("cached is null");
        }
        out.writeInt(this.requiredLibraries.length);
        for (i = 0; i < this.requiredLibraries.length; ++i) {
            StringRecord.writeString((DataOutput)out, (String)this.requiredLibraries[i]);
        }
        out.writeInt(this.cached.length);
        for (i = 0; i < this.cached.length; ++i) {
            out.writeBoolean(this.cached[i]);
        }
    }
}

