/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskmanager;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.runtime.executiongraph.ExecutionVertexID;
import org.apache.flink.runtime.jobgraph.JobID;
import org.apache.flink.runtime.jobgraph.tasks.InputSplitProvider;
import org.apache.flink.runtime.jobmanager.splitassigner.InputSplitWrapper;
import org.apache.flink.runtime.protocols.InputSplitProviderProtocol;
import org.apache.flink.runtime.types.IntegerRecord;
import org.apache.flink.util.StringUtils;

public class TaskInputSplitProvider
implements InputSplitProvider {
    private final JobID jobID;
    private final ExecutionVertexID executionVertexID;
    private final InputSplitProviderProtocol globalInputSplitProvider;
    private final AtomicInteger sequenceNumber = new AtomicInteger(0);

    TaskInputSplitProvider(JobID jobID, ExecutionVertexID executionVertexID, InputSplitProviderProtocol globalInputSplitProvider) {
        this.jobID = jobID;
        this.executionVertexID = executionVertexID;
        this.globalInputSplitProvider = globalInputSplitProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputSplit getNextInputSplit() {
        try {
            InputSplitProviderProtocol inputSplitProviderProtocol = this.globalInputSplitProvider;
            synchronized (inputSplitProviderProtocol) {
                InputSplitWrapper wrapper = this.globalInputSplitProvider.requestNextInputSplit(this.jobID, this.executionVertexID, new IntegerRecord(this.sequenceNumber.getAndIncrement()));
                return wrapper.getInputSplit();
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(StringUtils.stringifyException((Throwable)ioe));
        }
    }
}

