/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.memorymanager;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;

public class CheckedMemorySegment {
    protected byte[] memory;
    protected final int offset;
    protected final int size;
    protected ByteBuffer wrapper;

    public CheckedMemorySegment(byte[] memory) {
        this.memory = memory;
        this.offset = 0;
        this.size = memory.length;
    }

    public boolean isFreed() {
        return this.memory == null;
    }

    public final int size() {
        return this.size;
    }

    public final byte[] getBackingArray() {
        return this.memory;
    }

    public final int translateOffset(int offset) {
        return this.offset + offset;
    }

    public ByteBuffer wrap(int offset, int length) {
        if (offset > this.size || offset > this.size - length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.wrapper == null) {
            this.wrapper = ByteBuffer.wrap(this.memory, this.offset + offset, length);
        } else {
            this.wrapper.position(this.offset + offset);
            this.wrapper.limit(this.offset + offset + length);
        }
        return this.wrapper;
    }

    public final byte get(int index) {
        if (index >= 0 && index < this.size) {
            return this.memory[this.offset + index];
        }
        throw new IndexOutOfBoundsException();
    }

    public final CheckedMemorySegment put(int index, byte b) {
        if (index >= 0 && index < this.size) {
            this.memory[this.offset + index] = b;
            return this;
        }
        throw new IndexOutOfBoundsException();
    }

    public final CheckedMemorySegment get(int index, byte[] dst) {
        return this.get(index, dst, 0, dst.length);
    }

    public final CheckedMemorySegment put(int index, byte[] src) {
        return this.put(index, src, 0, src.length);
    }

    public final CheckedMemorySegment get(int index, byte[] dst, int offset, int length) {
        if (index >= 0 && index < this.size && index <= this.size - length && offset <= dst.length - length) {
            System.arraycopy(this.memory, this.offset + index, dst, offset, length);
            return this;
        }
        throw new IndexOutOfBoundsException();
    }

    public final CheckedMemorySegment put(int index, byte[] src, int offset, int length) {
        if (index >= 0 && index < this.size && index <= this.size - length && offset <= src.length - length) {
            System.arraycopy(src, offset, this.memory, this.offset + index, length);
            return this;
        }
        throw new IndexOutOfBoundsException();
    }

    public final CheckedMemorySegment get(DataOutput out, int offset, int length) throws IOException {
        if (offset >= 0 && offset < this.size && length >= 0 && offset <= this.size - length) {
            out.write(this.memory, this.offset + offset, length);
            return this;
        }
        throw new IndexOutOfBoundsException();
    }

    public final CheckedMemorySegment put(DataInput in, int offset, int length) throws IOException {
        if (offset >= 0 && offset < this.size && length >= 0 && offset <= this.size - length) {
            in.readFully(this.memory, this.offset + offset, length);
            return this;
        }
        throw new IndexOutOfBoundsException();
    }

    public final boolean getBoolean(int index) {
        if (index >= 0 && index < this.size) {
            return this.memory[this.offset + index] != 0;
        }
        throw new IndexOutOfBoundsException();
    }

    public final CheckedMemorySegment putBoolean(int index, boolean value) {
        if (index >= 0 && index < this.size) {
            this.memory[this.offset + index] = (byte)(value ? 1 : 0);
            return this;
        }
        throw new IndexOutOfBoundsException();
    }

    public final char getChar(int index) {
        if (index >= 0 && index < this.size - 1) {
            return (char)((this.memory[this.offset + index + 0] & 0xFF) << 8 | this.memory[this.offset + index + 1] & 0xFF);
        }
        throw new IndexOutOfBoundsException();
    }

    public final CheckedMemorySegment putChar(int index, char value) {
        if (index >= 0 && index < this.size - 1) {
            this.memory[this.offset + index + 0] = (byte)(value >> 8);
            this.memory[this.offset + index + 1] = (byte)value;
            return this;
        }
        throw new IndexOutOfBoundsException();
    }

    public final short getShort(int index) {
        if (index >= 0 && index < this.size - 1) {
            return (short)((this.memory[this.offset + index + 0] & 0xFF) << 8 | this.memory[this.offset + index + 1] & 0xFF);
        }
        throw new IndexOutOfBoundsException();
    }

    public final CheckedMemorySegment putShort(int index, short value) {
        if (index >= 0 && index < this.size - 1) {
            this.memory[this.offset + index + 0] = (byte)(value >> 8);
            this.memory[this.offset + index + 1] = (byte)value;
            return this;
        }
        throw new IndexOutOfBoundsException();
    }

    public final int getInt(int index) {
        if (index >= 0 && index < this.size - 3) {
            return (this.memory[index] & 0xFF) << 24 | (this.memory[index + 1] & 0xFF) << 16 | (this.memory[index + 2] & 0xFF) << 8 | this.memory[index + 3] & 0xFF;
        }
        throw new IndexOutOfBoundsException();
    }

    public final int getIntLittleEndian(int index) {
        if (index >= 0 && index < this.size - 3) {
            return this.memory[index] & 0xFF | (this.memory[index + 1] & 0xFF) << 8 | (this.memory[index + 2] & 0xFF) << 16 | (this.memory[index + 3] & 0xFF) << 24;
        }
        throw new IndexOutOfBoundsException();
    }

    public final int getIntBigEndian(int index) {
        if (index >= 0 && index < this.size - 3) {
            return (this.memory[index] & 0xFF) << 24 | (this.memory[index + 1] & 0xFF) << 16 | (this.memory[index + 2] & 0xFF) << 8 | this.memory[index + 3] & 0xFF;
        }
        throw new IndexOutOfBoundsException();
    }

    public final void putInt(int index, int value) {
        if (index < 0 || index >= this.size - 3) {
            throw new IndexOutOfBoundsException();
        }
        this.memory[index] = (byte)(value >> 24);
        this.memory[index + 1] = (byte)(value >> 16);
        this.memory[index + 2] = (byte)(value >> 8);
        this.memory[index + 3] = (byte)value;
    }

    public final void putIntLittleEndian(int index, int value) {
        if (index < 0 || index >= this.size - 3) {
            throw new IndexOutOfBoundsException();
        }
        this.memory[index] = (byte)value;
        this.memory[index + 1] = (byte)(value >> 8);
        this.memory[index + 2] = (byte)(value >> 16);
        this.memory[index + 3] = (byte)(value >> 24);
    }

    public final void putIntBigEndian(int index, int value) {
        if (index < 0 || index >= this.size - 3) {
            throw new IndexOutOfBoundsException();
        }
        this.memory[index] = (byte)(value >> 24);
        this.memory[index + 1] = (byte)(value >> 16);
        this.memory[index + 2] = (byte)(value >> 8);
        this.memory[index + 3] = (byte)value;
    }

    public final long getLong(int index) {
        if (index >= 0 && index < this.size - 7) {
            return ((long)this.memory[index] & 0xFFL) << 56 | ((long)this.memory[index + 1] & 0xFFL) << 48 | ((long)this.memory[index + 2] & 0xFFL) << 40 | ((long)this.memory[index + 3] & 0xFFL) << 32 | ((long)this.memory[index + 4] & 0xFFL) << 24 | ((long)this.memory[index + 5] & 0xFFL) << 16 | ((long)this.memory[index + 6] & 0xFFL) << 8 | (long)this.memory[index + 7] & 0xFFL;
        }
        throw new IndexOutOfBoundsException();
    }

    public final long getLongLittleEndian(int index) {
        if (index >= 0 && index < this.size - 7) {
            return (long)this.memory[index] & 0xFFL | ((long)this.memory[index + 1] & 0xFFL) << 8 | ((long)this.memory[index + 2] & 0xFFL) << 16 | ((long)this.memory[index + 3] & 0xFFL) << 24 | ((long)this.memory[index + 4] & 0xFFL) << 32 | ((long)this.memory[index + 5] & 0xFFL) << 40 | ((long)this.memory[index + 6] & 0xFFL) << 48 | ((long)this.memory[index + 7] & 0xFFL) << 56;
        }
        throw new IndexOutOfBoundsException();
    }

    public final long getLongBigEndian(int index) {
        if (index >= 0 && index < this.size - 7) {
            return ((long)this.memory[index] & 0xFFL) << 56 | ((long)this.memory[index + 1] & 0xFFL) << 48 | ((long)this.memory[index + 2] & 0xFFL) << 40 | ((long)this.memory[index + 3] & 0xFFL) << 32 | ((long)this.memory[index + 4] & 0xFFL) << 24 | ((long)this.memory[index + 5] & 0xFFL) << 16 | ((long)this.memory[index + 6] & 0xFFL) << 8 | (long)this.memory[index + 7] & 0xFFL;
        }
        throw new IndexOutOfBoundsException();
    }

    public final void putLong(int index, long value) {
        if (index < 0 || index >= this.size - 7) {
            throw new IndexOutOfBoundsException();
        }
        this.memory[index] = (byte)(value >> 56);
        this.memory[index + 1] = (byte)(value >> 48);
        this.memory[index + 2] = (byte)(value >> 40);
        this.memory[index + 3] = (byte)(value >> 32);
        this.memory[index + 4] = (byte)(value >> 24);
        this.memory[index + 5] = (byte)(value >> 16);
        this.memory[index + 6] = (byte)(value >> 8);
        this.memory[index + 7] = (byte)value;
    }

    public final void putLongLittleEndian(int index, long value) {
        if (index < 0 || index >= this.size - 7) {
            throw new IndexOutOfBoundsException();
        }
        this.memory[index] = (byte)value;
        this.memory[index + 1] = (byte)(value >> 8);
        this.memory[index + 2] = (byte)(value >> 16);
        this.memory[index + 3] = (byte)(value >> 24);
        this.memory[index + 4] = (byte)(value >> 32);
        this.memory[index + 5] = (byte)(value >> 40);
        this.memory[index + 6] = (byte)(value >> 48);
        this.memory[index + 7] = (byte)(value >> 56);
    }

    public final void putLongBigEndian(int index, long value) {
        if (index < 0 || index >= this.size - 7) {
            throw new IndexOutOfBoundsException();
        }
        this.memory[index] = (byte)(value >> 56);
        this.memory[index + 1] = (byte)(value >> 48);
        this.memory[index + 2] = (byte)(value >> 40);
        this.memory[index + 3] = (byte)(value >> 32);
        this.memory[index + 4] = (byte)(value >> 24);
        this.memory[index + 5] = (byte)(value >> 16);
        this.memory[index + 6] = (byte)(value >> 8);
        this.memory[index + 7] = (byte)value;
    }

    public final float getFloat(int index) {
        return Float.intBitsToFloat(this.getInt(index));
    }

    public final CheckedMemorySegment putFloat(int index, float value) {
        this.putLong(index, Float.floatToIntBits(value));
        return this;
    }

    public final double getDouble(int index) {
        return Double.longBitsToDouble(this.getLong(index));
    }

    public final CheckedMemorySegment putDouble(int index, double value) {
        this.putLong(index, Double.doubleToLongBits(value));
        return this;
    }
}

