/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager.web;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.servlet.Servlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.runtime.jobmanager.JobManager;
import org.apache.flink.runtime.jobmanager.web.JobmanagerInfoServlet;
import org.apache.flink.runtime.jobmanager.web.LogfileInfoServlet;
import org.apache.flink.runtime.jobmanager.web.MenuServlet;
import org.apache.flink.runtime.jobmanager.web.SetupInfoServlet;
import org.eclipse.jetty.http.security.Constraint;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class WebInfoServer {
    private static final Log LOG = LogFactory.getLog(WebInfoServer.class);
    private final Server server;
    private int port;

    public WebInfoServer(Configuration nepheleConfig, int port, JobManager jobmanager) throws IOException {
        this.port = port;
        if (nepheleConfig == null) {
            nepheleConfig = GlobalConfiguration.getConfiguration();
        }
        String basePath = nepheleConfig.getString("flink.base.dir.path", "");
        String webDirPath = nepheleConfig.getString("jobmanager.web.rootpath", "./resources/web-docs-infoserver/");
        String logDirPath = nepheleConfig.getString("jobmanager.web.logpath", basePath + "/log");
        File webDir = webDirPath.startsWith("/") ? new File(webDirPath) : new File(basePath + "/" + webDirPath);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Setting up web info server, using web-root directory '" + webDir.getAbsolutePath() + "'."));
            LOG.info((Object)("Web info server will display information about nephele job-manager on " + nepheleConfig.getString("jobmanager.rpc.address", null) + ", port " + port + "."));
        }
        if (!webDir.exists()) {
            throw new FileNotFoundException("Cannot start jobmanager web info server. The directory containing the web documents does not exist: " + webDir.getAbsolutePath());
        }
        this.server = new Server(port);
        ServletContextHandler servletContext = new ServletContextHandler(1);
        servletContext.setContextPath("/");
        servletContext.addServlet(new ServletHolder((Servlet)new JobmanagerInfoServlet(jobmanager)), "/jobsInfo");
        servletContext.addServlet(new ServletHolder((Servlet)new LogfileInfoServlet(new File(logDirPath))), "/logInfo");
        servletContext.addServlet(new ServletHolder((Servlet)new SetupInfoServlet(jobmanager)), "/setupInfo");
        servletContext.addServlet(new ServletHolder((Servlet)new MenuServlet()), "/menu");
        ResourceHandler resourceHandler = new ResourceHandler();
        resourceHandler.setDirectoriesListed(false);
        resourceHandler.setResourceBase(webDir.getAbsolutePath());
        HandlerList handlers = new HandlerList();
        handlers.addHandler((Handler)servletContext);
        handlers.addHandler((Handler)resourceHandler);
        File af = null;
        String authFile = nepheleConfig.getString("jobmanager.web.access", null);
        if (authFile != null && !(af = new File(authFile)).exists()) {
            LOG.error((Object)("The specified file '" + af.getAbsolutePath() + "' with the authentication information is missing. Starting server without HTTP authentication."));
            af = null;
        }
        if (af != null) {
            HashLoginService loginService = new HashLoginService("Flink Jobmanager Interface", authFile);
            this.server.addBean((Object)loginService);
            Constraint constraint = new Constraint();
            constraint.setName("BASIC");
            constraint.setAuthenticate(true);
            constraint.setRoles(new String[]{"user"});
            ConstraintMapping mapping = new ConstraintMapping();
            mapping.setPathSpec("/*");
            mapping.setConstraint(constraint);
            ConstraintSecurityHandler sh = new ConstraintSecurityHandler();
            sh.addConstraintMapping(mapping);
            sh.setAuthenticator((Authenticator)new BasicAuthenticator());
            sh.setLoginService((LoginService)loginService);
            sh.setStrict(true);
            sh.setHandler((Handler)handlers);
            this.server.setHandler((Handler)sh);
        } else {
            this.server.setHandler((Handler)handlers);
        }
    }

    public void start() throws Exception {
        LOG.info((Object)("Starting web info server for JobManager on port " + this.port));
        this.server.start();
    }
}

