/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.iterative.task;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.api.common.functions.Function;
import org.apache.flink.runtime.io.network.api.BufferWriter;
import org.apache.flink.runtime.iterative.concurrent.SuperstepKickoffLatch;
import org.apache.flink.runtime.iterative.concurrent.SuperstepKickoffLatchBroker;
import org.apache.flink.runtime.iterative.io.WorksetUpdateOutputCollector;
import org.apache.flink.runtime.iterative.task.AbstractIterativePactTask;
import org.apache.flink.util.Collector;

public class IterationIntermediatePactTask<S extends Function, OT>
extends AbstractIterativePactTask<S, OT> {
    private static final Log log = LogFactory.getLog(IterationIntermediatePactTask.class);
    private WorksetUpdateOutputCollector<OT> worksetUpdateOutputCollector;

    @Override
    protected void initialize() throws Exception {
        super.initialize();
        Collector delegate = this.getLastOutputCollector();
        if (this.isWorksetUpdate) {
            if (this.isSolutionSetUpdate) {
                throw new IllegalStateException("Plan bug: Intermediate task performs workset and solutions set update.");
            }
            Collector outputCollector = this.createWorksetUpdateOutputCollector(delegate);
            if (this.isWorksetIteration) {
                this.worksetUpdateOutputCollector = (WorksetUpdateOutputCollector)outputCollector;
            }
            this.setLastOutputCollector(outputCollector);
        } else if (this.isSolutionSetUpdate) {
            this.setLastOutputCollector(this.createSolutionSetUpdateOutputCollector(delegate));
        }
    }

    @Override
    public void run() throws Exception {
        SuperstepKickoffLatch nextSuperstepLatch = SuperstepKickoffLatchBroker.instance().get(this.brokerKey());
        while (this.running && !this.terminationRequested()) {
            boolean terminated;
            if (log.isInfoEnabled()) {
                log.info((Object)this.formatLogString("starting iteration [" + this.currentIteration() + "]"));
            }
            super.run();
            this.verifyEndOfSuperstepState();
            if (this.isWorksetUpdate && this.isWorksetIteration) {
                long numCollected = this.worksetUpdateOutputCollector.getElementsCollectedAndReset();
                this.worksetAggregator.aggregate(numCollected);
            }
            if (log.isInfoEnabled()) {
                log.info((Object)this.formatLogString("finishing iteration [" + this.currentIteration() + "]"));
            }
            this.sendEndOfSuperstep();
            if (this.isWorksetUpdate) {
                this.worksetBackChannel.notifyOfEndOfSuperstep();
            }
            if (terminated = nextSuperstepLatch.awaitStartOfSuperstepOrTermination(this.currentIteration() + 1)) {
                this.requestTermination();
                continue;
            }
            this.incrementIterationCounter();
        }
    }

    private void sendEndOfSuperstep() throws IOException, InterruptedException {
        for (BufferWriter eventualOutput : this.eventualOutputs) {
            eventualOutput.sendEndOfSuperstep();
        }
    }
}

