/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.disk;

import java.io.EOFException;
import java.util.ArrayList;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.SeekableDataInputView;
import org.apache.flink.runtime.memorymanager.AbstractPagedInputView;
import org.apache.flink.runtime.util.MathUtils;

public class RandomAccessInputView
extends AbstractPagedInputView
implements SeekableDataInputView {
    private final ArrayList<MemorySegment> segments;
    private int currentSegmentIndex;
    private final int segmentSizeBits;
    private final int segmentSizeMask;
    private final int segmentSize;
    private final int limitInLastSegment;

    public RandomAccessInputView(ArrayList<MemorySegment> segments, int segmentSize) {
        this(segments, segmentSize, segmentSize);
    }

    public RandomAccessInputView(ArrayList<MemorySegment> segments, int segmentSize, int limitInLastSegment) {
        super(segments.get(0), segments.size() > 1 ? segmentSize : limitInLastSegment, 0);
        this.segments = segments;
        this.currentSegmentIndex = 0;
        this.segmentSize = segmentSize;
        this.segmentSizeBits = MathUtils.log2strict(segmentSize);
        this.segmentSizeMask = segmentSize - 1;
        this.limitInLastSegment = limitInLastSegment;
    }

    public void setReadPosition(long position) {
        int bufferNum = (int)(position >>> this.segmentSizeBits);
        int offset = (int)(position & (long)this.segmentSizeMask);
        this.currentSegmentIndex = bufferNum;
        this.seekInput(this.segments.get(bufferNum), offset, bufferNum < this.segments.size() - 1 ? this.segmentSize : this.limitInLastSegment);
    }

    @Override
    protected MemorySegment nextSegment(MemorySegment current) throws EOFException {
        if (++this.currentSegmentIndex < this.segments.size()) {
            return this.segments.get(this.currentSegmentIndex);
        }
        throw new EOFException();
    }

    @Override
    protected int getLimitForSegment(MemorySegment segment) {
        return this.currentSegmentIndex == this.segments.size() - 1 ? this.limitInLastSegment : this.segmentSize;
    }
}

