/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.runtime.deployment.ChannelDeploymentDescriptor;
import org.apache.flink.runtime.deployment.GateDeploymentDescriptor;
import org.apache.flink.runtime.deployment.TaskDeploymentDescriptor;
import org.apache.flink.runtime.execution.ExecutionListener;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.execution.ExecutionStateTransition;
import org.apache.flink.runtime.executiongraph.ExecutionEdge;
import org.apache.flink.runtime.executiongraph.ExecutionGate;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionGroupVertex;
import org.apache.flink.runtime.executiongraph.ExecutionPipeline;
import org.apache.flink.runtime.executiongraph.ExecutionVertexID;
import org.apache.flink.runtime.executiongraph.VertexAssignmentListener;
import org.apache.flink.runtime.instance.AllocatedResource;
import org.apache.flink.runtime.instance.AllocationID;
import org.apache.flink.runtime.io.network.gates.GateID;
import org.apache.flink.runtime.taskmanager.AbstractTaskResult;
import org.apache.flink.runtime.taskmanager.TaskCancelResult;
import org.apache.flink.runtime.taskmanager.TaskKillResult;
import org.apache.flink.runtime.taskmanager.TaskSubmissionResult;
import org.apache.flink.runtime.util.AtomicEnum;
import org.apache.flink.runtime.util.SerializableArrayList;
import org.apache.flink.util.StringUtils;

public final class ExecutionVertex {
    private static final Log LOG = LogFactory.getLog(ExecutionVertex.class);
    private final ExecutionVertexID vertexID;
    private final ExecutionGroupVertex groupVertex;
    private final ExecutionGraph executionGraph;
    private final AtomicReference<AllocatedResource> allocatedResource = new AtomicReference<Object>(null);
    private volatile AllocationID allocationID = null;
    private final CopyOnWriteArrayList<VertexAssignmentListener> vertexAssignmentListeners = new CopyOnWriteArrayList();
    private final ConcurrentMap<Integer, ExecutionListener> executionListeners = new ConcurrentSkipListMap<Integer, ExecutionListener>();
    private final AtomicEnum<ExecutionState> executionState = new AtomicEnum<ExecutionState>(ExecutionState.CREATED);
    private final ExecutionGate[] outputGates;
    private final ExecutionGate[] inputGates;
    private volatile int indexInVertexGroup = 0;
    private final AtomicInteger retriesLeft;
    private final AtomicReference<ExecutionPipeline> executionPipeline = new AtomicReference<Object>(null);
    private final AtomicBoolean cancelRequested = new AtomicBoolean(false);

    public ExecutionVertex(ExecutionGraph executionGraph, ExecutionGroupVertex groupVertex, int numberOfOutputGates, int numberOfInputGates) {
        this(new ExecutionVertexID(), executionGraph, groupVertex, numberOfOutputGates, numberOfInputGates);
        this.groupVertex.addInitialSubtask(this);
    }

    private ExecutionVertex(ExecutionVertexID vertexID, ExecutionGraph executionGraph, ExecutionGroupVertex groupVertex, int numberOfOutputGates, int numberOfInputGates) {
        this.vertexID = vertexID;
        this.executionGraph = executionGraph;
        this.groupVertex = groupVertex;
        this.retriesLeft = new AtomicInteger(groupVertex.getNumberOfExecutionRetries());
        this.outputGates = new ExecutionGate[numberOfOutputGates];
        this.inputGates = new ExecutionGate[numberOfInputGates];
        this.executionGraph.registerExecutionVertex(this);
        this.registerExecutionListener(this.executionGraph);
    }

    public ExecutionGroupVertex getGroupVertex() {
        return this.groupVertex;
    }

    public String getName() {
        return this.groupVertex.getName();
    }

    public ExecutionVertex duplicateVertex(boolean preserveVertexID) {
        int i;
        ExecutionVertexID newVertexID = preserveVertexID ? this.vertexID : new ExecutionVertexID();
        ExecutionVertex duplicatedVertex = new ExecutionVertex(newVertexID, this.executionGraph, this.groupVertex, this.outputGates.length, this.inputGates.length);
        for (i = 0; i < this.outputGates.length; ++i) {
            duplicatedVertex.outputGates[i] = new ExecutionGate(new GateID(), duplicatedVertex, this.outputGates[i].getGroupEdge(), false);
        }
        for (i = 0; i < this.inputGates.length; ++i) {
            duplicatedVertex.inputGates[i] = new ExecutionGate(new GateID(), duplicatedVertex, this.inputGates[i].getGroupEdge(), true);
        }
        duplicatedVertex.setAllocatedResource(this.allocatedResource.get());
        return duplicatedVertex;
    }

    void insertOutputGate(int pos, ExecutionGate outputGate) {
        if (this.outputGates[pos] != null) {
            throw new IllegalStateException("Output gate at position " + pos + " is not null");
        }
        this.outputGates[pos] = outputGate;
    }

    void insertInputGate(int pos, ExecutionGate inputGate) {
        if (this.inputGates[pos] != null) {
            throw new IllegalStateException("Input gate at position " + pos + " is not null");
        }
        this.inputGates[pos] = inputGate;
    }

    public ExecutionVertex splitVertex() {
        return this.duplicateVertex(false);
    }

    public ExecutionState getExecutionState() {
        return this.executionState.get();
    }

    public void updateExecutionStateAsynchronously(final ExecutionState newExecutionState, final String optionalMessage) {
        Runnable command = new Runnable(){

            @Override
            public void run() {
                ExecutionVertex.this.updateExecutionState(newExecutionState, optionalMessage);
            }
        };
        this.executionGraph.executeCommand(command);
    }

    public void updateExecutionStateAsynchronously(ExecutionState newExecutionState) {
        this.updateExecutionStateAsynchronously(newExecutionState, null);
    }

    public ExecutionState updateExecutionState(ExecutionState newExecutionState) {
        return this.updateExecutionState(newExecutionState, null);
    }

    public ExecutionState updateExecutionState(ExecutionState newExecutionState, String optionalMessage) {
        ExecutionState previousState;
        if (newExecutionState == null) {
            throw new IllegalArgumentException("Argument newExecutionState must not be null");
        }
        ExecutionState currentExecutionState = this.executionState.get();
        if (currentExecutionState == ExecutionState.CANCELING) {
            if (newExecutionState == ExecutionState.FINISHING) {
                return currentExecutionState;
            }
            if (newExecutionState == ExecutionState.FINISHED) {
                LOG.info((Object)("Received transition from CANCELING to FINISHED for vertex " + this.toString() + ", converting it to CANCELED"));
                newExecutionState = ExecutionState.CANCELED;
            }
        }
        if ((previousState = this.executionState.getAndSet(newExecutionState)) == newExecutionState) {
            return previousState;
        }
        ExecutionStateTransition.checkTransition(true, this.toString(), previousState, newExecutionState);
        Iterator it = this.executionListeners.values().iterator();
        while (it.hasNext()) {
            ((ExecutionListener)it.next()).executionStateChanged(this.executionGraph.getJobID(), this.vertexID, newExecutionState, optionalMessage);
        }
        this.checkCancelRequestedFlag();
        return previousState;
    }

    public boolean compareAndUpdateExecutionState(ExecutionState expected, ExecutionState update) {
        if (update == null) {
            throw new IllegalArgumentException("Argument update must not be null");
        }
        if (!this.executionState.compareAndSet(expected, update)) {
            return false;
        }
        ExecutionStateTransition.checkTransition(true, this.toString(), expected, update);
        Iterator it = this.executionListeners.values().iterator();
        while (it.hasNext()) {
            ((ExecutionListener)it.next()).executionStateChanged(this.executionGraph.getJobID(), this.vertexID, update, null);
        }
        this.checkCancelRequestedFlag();
        return true;
    }

    private void checkCancelRequestedFlag() {
        TaskCancelResult tsr;
        if (this.cancelRequested.compareAndSet(true, false) && (tsr = this.cancelTask()).getReturnCode() != AbstractTaskResult.ReturnCode.SUCCESS && tsr.getReturnCode() != AbstractTaskResult.ReturnCode.TASK_NOT_FOUND) {
            LOG.error((Object)("Unable to cancel vertex " + this + ": " + tsr.getReturnCode().toString() + (tsr.getDescription() != null ? " (" + tsr.getDescription() + ")" : "")));
        }
    }

    public void setAllocatedResource(AllocatedResource allocatedResource) {
        if (allocatedResource == null) {
            throw new IllegalArgumentException("Argument allocatedResource must not be null");
        }
        AllocatedResource previousResource = this.allocatedResource.getAndSet(allocatedResource);
        if (previousResource != null) {
            previousResource.removeVertexFromResource(this);
        }
        allocatedResource.assignVertexToResource(this);
        Iterator<VertexAssignmentListener> it = this.vertexAssignmentListeners.iterator();
        while (it.hasNext()) {
            it.next().vertexAssignmentChanged(this.vertexID, allocatedResource);
        }
    }

    public AllocatedResource getAllocatedResource() {
        return this.allocatedResource.get();
    }

    public AllocationID getAllocationID() {
        return this.allocationID;
    }

    public ExecutionVertexID getID() {
        return this.vertexID;
    }

    public int getNumberOfPredecessors() {
        int numberOfPredecessors = 0;
        for (int i = 0; i < this.inputGates.length; ++i) {
            numberOfPredecessors += this.inputGates[i].getNumberOfEdges();
        }
        return numberOfPredecessors;
    }

    public int getNumberOfSuccessors() {
        int numberOfSuccessors = 0;
        for (int i = 0; i < this.outputGates.length; ++i) {
            numberOfSuccessors += this.outputGates[i].getNumberOfEdges();
        }
        return numberOfSuccessors;
    }

    public ExecutionVertex getPredecessor(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Argument index must be greather or equal to 0");
        }
        for (int i = 0; i < this.inputGates.length; ++i) {
            ExecutionGate inputGate = this.inputGates[i];
            int numberOfEdges = inputGate.getNumberOfEdges();
            if (index >= 0 && index < numberOfEdges) {
                ExecutionEdge edge = inputGate.getEdge(index);
                return edge.getOutputGate().getVertex();
            }
            index -= numberOfEdges;
        }
        return null;
    }

    public ExecutionVertex getSuccessor(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Argument index must be greather or equal to 0");
        }
        for (int i = 0; i < this.outputGates.length; ++i) {
            ExecutionGate outputGate = this.outputGates[i];
            int numberOfEdges = outputGate.getNumberOfEdges();
            if (index >= 0 && index < numberOfEdges) {
                ExecutionEdge edge = outputGate.getEdge(index);
                return edge.getInputGate().getVertex();
            }
            index -= numberOfEdges;
        }
        return null;
    }

    public boolean isInputVertex() {
        return this.groupVertex.isInputVertex();
    }

    public boolean isOutputVertex() {
        return this.groupVertex.isOutputVertex();
    }

    public int getIndexInVertexGroup() {
        return this.indexInVertexGroup;
    }

    void setIndexInVertexGroup(int indexInVertexGroup) {
        this.indexInVertexGroup = indexInVertexGroup;
    }

    public int getNumberOfOutputGates() {
        return this.outputGates.length;
    }

    public ExecutionGate getOutputGate(int index) {
        return this.outputGates[index];
    }

    public int getNumberOfInputGates() {
        return this.inputGates.length;
    }

    public ExecutionGate getInputGate(int index) {
        return this.inputGates[index];
    }

    public TaskSubmissionResult startTask() {
        AllocatedResource ar = this.allocatedResource.get();
        if (ar == null) {
            TaskSubmissionResult result = new TaskSubmissionResult(this.getID(), AbstractTaskResult.ReturnCode.NO_INSTANCE);
            result.setDescription("Assigned instance of vertex " + this.toString() + " is null!");
            return result;
        }
        SerializableArrayList<TaskDeploymentDescriptor> tasks = new SerializableArrayList<TaskDeploymentDescriptor>();
        tasks.add(this.constructDeploymentDescriptor());
        try {
            List<TaskSubmissionResult> results = ar.getInstance().submitTasks(tasks);
            return results.get(0);
        }
        catch (IOException e) {
            TaskSubmissionResult result = new TaskSubmissionResult(this.getID(), AbstractTaskResult.ReturnCode.IPC_ERROR);
            result.setDescription(StringUtils.stringifyException((Throwable)e));
            return result;
        }
    }

    public TaskKillResult killTask() {
        ExecutionState state = this.executionState.get();
        if (state != ExecutionState.RUNNING) {
            TaskKillResult result = new TaskKillResult(this.getID(), AbstractTaskResult.ReturnCode.ILLEGAL_STATE);
            result.setDescription("Vertex " + this.toString() + " is in state " + (Object)((Object)state));
            return result;
        }
        AllocatedResource ar = this.allocatedResource.get();
        if (ar == null) {
            TaskKillResult result = new TaskKillResult(this.getID(), AbstractTaskResult.ReturnCode.NO_INSTANCE);
            result.setDescription("Assigned instance of vertex " + this.toString() + " is null!");
            return result;
        }
        try {
            return ar.getInstance().killTask(this.vertexID);
        }
        catch (IOException e) {
            TaskKillResult result = new TaskKillResult(this.getID(), AbstractTaskResult.ReturnCode.IPC_ERROR);
            result.setDescription(StringUtils.stringifyException((Throwable)e));
            return result;
        }
    }

    public TaskCancelResult cancelTask() {
        ExecutionState previousState;
        while (true) {
            if ((previousState = this.executionState.get()) == ExecutionState.CANCELED) {
                return new TaskCancelResult(this.getID(), AbstractTaskResult.ReturnCode.SUCCESS);
            }
            if (previousState == ExecutionState.FAILED) {
                return new TaskCancelResult(this.getID(), AbstractTaskResult.ReturnCode.SUCCESS);
            }
            if (previousState == ExecutionState.FINISHED) {
                return new TaskCancelResult(this.getID(), AbstractTaskResult.ReturnCode.SUCCESS);
            }
            if (previousState == ExecutionState.CANCELING) {
                return new TaskCancelResult(this.getID(), AbstractTaskResult.ReturnCode.SUCCESS);
            }
            if (previousState == ExecutionState.STARTING) {
                this.cancelRequested.set(true);
                if (this.executionState.get() != ExecutionState.STARTING) {
                    this.cancelRequested.set(false);
                    continue;
                }
                return new TaskCancelResult(this.getID(), AbstractTaskResult.ReturnCode.SUCCESS);
            }
            if (this.compareAndUpdateExecutionState(previousState, ExecutionState.CANCELING)) break;
        }
        if (this.groupVertex.getStageNumber() != this.executionGraph.getIndexOfCurrentExecutionStage()) {
            this.updateExecutionState(ExecutionState.CANCELED, null);
            return new TaskCancelResult(this.getID(), AbstractTaskResult.ReturnCode.SUCCESS);
        }
        if (previousState != ExecutionState.RUNNING && previousState != ExecutionState.FINISHING) {
            this.updateExecutionState(ExecutionState.CANCELED, null);
            return new TaskCancelResult(this.getID(), AbstractTaskResult.ReturnCode.SUCCESS);
        }
        AllocatedResource ar = this.allocatedResource.get();
        if (ar == null) {
            TaskCancelResult result = new TaskCancelResult(this.getID(), AbstractTaskResult.ReturnCode.NO_INSTANCE);
            result.setDescription("Assigned instance of vertex " + this.toString() + " is null!");
            return result;
        }
        try {
            return ar.getInstance().cancelTask(this.vertexID);
        }
        catch (IOException e) {
            TaskCancelResult result = new TaskCancelResult(this.getID(), AbstractTaskResult.ReturnCode.IPC_ERROR);
            result.setDescription(StringUtils.stringifyException((Throwable)e));
            return result;
        }
    }

    public ExecutionGraph getExecutionGraph() {
        return this.executionGraph;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.groupVertex.getName());
        sb.append(" (");
        sb.append(this.indexInVertexGroup + 1);
        sb.append('/');
        sb.append(this.groupVertex.getCurrentNumberOfGroupMembers());
        sb.append(')');
        return sb.toString();
    }

    @Deprecated
    public boolean hasRetriesLeft() {
        return this.retriesLeft.get() > 0;
    }

    public boolean decrementRetriesLeftAndCheck() {
        return this.retriesLeft.decrementAndGet() > 0;
    }

    public void registerVertexAssignmentListener(VertexAssignmentListener vertexAssignmentListener) {
        this.vertexAssignmentListeners.addIfAbsent(vertexAssignmentListener);
    }

    public void unregisterVertexAssignmentListener(VertexAssignmentListener vertexAssignmentListener) {
        this.vertexAssignmentListeners.remove(vertexAssignmentListener);
    }

    public void registerExecutionListener(ExecutionListener executionListener) {
        Integer priority = executionListener.getPriority();
        if (priority < 0) {
            LOG.error((Object)("Priority for execution listener " + executionListener.getClass() + " must be non-negative."));
            return;
        }
        ExecutionListener previousValue = this.executionListeners.putIfAbsent(priority, executionListener);
        if (previousValue != null) {
            LOG.error((Object)("Cannot register " + executionListener.getClass() + " as an execution listener. Priority " + priority + " is already taken."));
        }
    }

    public void unregisterExecutionListener(ExecutionListener executionListener) {
        this.executionListeners.remove(executionListener.getPriority());
    }

    void setExecutionPipeline(ExecutionPipeline executionPipeline) {
        ExecutionPipeline oldPipeline = this.executionPipeline.getAndSet(executionPipeline);
        if (oldPipeline != null) {
            oldPipeline.removeFromPipeline(this);
        }
        executionPipeline.addToPipeline(this);
    }

    public ExecutionPipeline getExecutionPipeline() {
        return this.executionPipeline.get();
    }

    public TaskDeploymentDescriptor constructDeploymentDescriptor() {
        SerializableArrayList<GateDeploymentDescriptor> ogd = new SerializableArrayList<GateDeploymentDescriptor>(this.outputGates.length);
        for (int i = 0; i < this.outputGates.length; ++i) {
            ExecutionGate eg = this.outputGates[i];
            ArrayList<ChannelDeploymentDescriptor> cdd = new ArrayList<ChannelDeploymentDescriptor>(eg.getNumberOfEdges());
            int numberOfOutputChannels = eg.getNumberOfEdges();
            for (int j = 0; j < numberOfOutputChannels; ++j) {
                ExecutionEdge ee = eg.getEdge(j);
                cdd.add(new ChannelDeploymentDescriptor(ee.getOutputChannelID(), ee.getInputChannelID()));
            }
            ogd.add(new GateDeploymentDescriptor(eg.getGateID(), eg.getChannelType(), cdd));
        }
        SerializableArrayList<GateDeploymentDescriptor> igd = new SerializableArrayList<GateDeploymentDescriptor>(this.inputGates.length);
        for (int i = 0; i < this.inputGates.length; ++i) {
            ExecutionGate eg = this.inputGates[i];
            ArrayList<ChannelDeploymentDescriptor> cdd = new ArrayList<ChannelDeploymentDescriptor>(eg.getNumberOfEdges());
            int numberOfInputChannels = eg.getNumberOfEdges();
            for (int j = 0; j < numberOfInputChannels; ++j) {
                ExecutionEdge ee = eg.getEdge(j);
                cdd.add(new ChannelDeploymentDescriptor(ee.getOutputChannelID(), ee.getInputChannelID()));
            }
            igd.add(new GateDeploymentDescriptor(eg.getGateID(), eg.getChannelType(), cdd));
        }
        TaskDeploymentDescriptor tdd = new TaskDeploymentDescriptor(this.executionGraph.getJobID(), this.vertexID, this.groupVertex.getName(), this.indexInVertexGroup, this.groupVertex.getCurrentNumberOfGroupMembers(), this.executionGraph.getJobConfiguration(), this.groupVertex.getConfiguration(), this.groupVertex.getInvokableClass(), ogd, igd);
        return tdd;
    }
}

