/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

public final class MathUtils {
    public static final int log2floor(int value) throws ArithmeticException {
        if (value == 0) {
            throw new ArithmeticException("Logarithm of zero is undefined.");
        }
        int log = 0;
        while ((value >>>= 1) != 0) {
            ++log;
        }
        return log;
    }

    public static final int log2strict(int value) throws ArithmeticException, IllegalArgumentException {
        if (value == 0) {
            throw new ArithmeticException("Logarithm of zero is undefined.");
        }
        if ((value & value - 1) != 0) {
            throw new IllegalArgumentException("The given value " + value + " is not a power of two.");
        }
        int log = 0;
        while ((value >>>= 1) != 0) {
            ++log;
        }
        return log;
    }

    public static final int roundDownToPowerOf2(int value) {
        return Integer.highestOneBit(value);
    }

    public static final int checkedDownCast(long value) {
        if (value > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Cannot downcast long value " + value + " to integer.");
        }
        return (int)value;
    }

    private MathUtils() {
    }
}

