/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.flink.core.io.StringRecord;

public final class EnumUtils {
    private EnumUtils() {
    }

    public static <T extends Enum<T>> T readEnum(DataInput in, Class<T> enumType) throws IOException {
        if (!in.readBoolean()) {
            return null;
        }
        return Enum.valueOf(enumType, StringRecord.readString((DataInput)in));
    }

    public static void writeEnum(DataOutput out, Enum<?> enumVal) throws IOException {
        if (enumVal == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            StringRecord.writeString((DataOutput)out, (String)enumVal.name());
        }
    }
}

