/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.profiling.impl.types;

import java.io.IOException;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.executiongraph.ExecutionVertexID;
import org.apache.flink.runtime.jobgraph.JobID;
import org.apache.flink.runtime.profiling.impl.types.InternalProfilingData;

public class InternalOutputGateProfilingData
implements InternalProfilingData {
    private final ExecutionVertexID executionVertexID;
    private final JobID jobId;
    private int gateIndex;
    private int profilingInternval;
    private int channelCapacityExhaustedCounter;

    public InternalOutputGateProfilingData() {
        this.jobId = new JobID();
        this.executionVertexID = new ExecutionVertexID();
        this.gateIndex = 0;
        this.profilingInternval = 0;
        this.channelCapacityExhaustedCounter = 0;
    }

    public InternalOutputGateProfilingData(JobID jobID, ExecutionVertexID executionVertexID, int gateIndex, int profilingInterval, int channelCapacityExhaustedCounter) {
        this.jobId = jobID;
        this.executionVertexID = executionVertexID;
        this.gateIndex = gateIndex;
        this.profilingInternval = profilingInterval;
        this.channelCapacityExhaustedCounter = channelCapacityExhaustedCounter;
    }

    public void read(DataInputView in) throws IOException {
        this.jobId.read(in);
        this.executionVertexID.read(in);
        this.gateIndex = in.readInt();
        this.profilingInternval = in.readInt();
        this.channelCapacityExhaustedCounter = in.readInt();
    }

    public void write(DataOutputView out) throws IOException {
        this.jobId.write(out);
        this.executionVertexID.write(out);
        out.writeInt(this.gateIndex);
        out.writeInt(this.profilingInternval);
        out.writeInt(this.channelCapacityExhaustedCounter);
    }

    public JobID getJobID() {
        return this.jobId;
    }

    public ExecutionVertexID getExecutionVertexID() {
        return this.executionVertexID;
    }

    public int getGateIndex() {
        return this.gateIndex;
    }

    public int getProfilingInterval() {
        return this.profilingInternval;
    }

    public int getChannelCapacityExhaustedCounter() {
        return this.channelCapacityExhaustedCounter;
    }
}

