/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.util;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.io.network.api.MutableReader;
import org.apache.flink.runtime.plugable.DeserializationDelegate;
import org.apache.flink.util.MutableObjectIterator;

public final class ReaderIterator<T>
implements MutableObjectIterator<T> {
    private final MutableReader<DeserializationDelegate<T>> reader;
    private final DeserializationDelegate<T> delegate;

    public ReaderIterator(MutableReader<DeserializationDelegate<T>> reader, TypeSerializer<T> serializer) {
        this.reader = reader;
        this.delegate = new DeserializationDelegate<T>(serializer);
    }

    public T next(T target) throws IOException {
        this.delegate.setInstance(target);
        try {
            if (this.reader.next(this.delegate)) {
                return this.delegate.getInstance();
            }
            return null;
        }
        catch (InterruptedException e) {
            throw new IOException("Reader interrupted.", e);
        }
    }
}

