/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.hash;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentSource;
import org.apache.flink.runtime.io.disk.iomanager.BlockChannelWriter;
import org.apache.flink.runtime.io.disk.iomanager.BulkBlockChannelReader;
import org.apache.flink.runtime.io.disk.iomanager.Channel;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.operators.hash.HashPartition;

public class ReOpenableHashPartition<BT, PT>
extends HashPartition<BT, PT> {
    protected int initialPartitionBuffersCount = -1;
    private Channel.ID initialBuildSideChannel = null;
    private BlockChannelWriter initialBuildSideWriter = null;
    private boolean isRestored = false;

    int getInitialPartitionBuffersCount() {
        if (this.initialPartitionBuffersCount == -1) {
            throw new RuntimeException("Hash Join: Bug: This partition is most likely a spilled partition that is not restorable");
        }
        return this.initialPartitionBuffersCount;
    }

    ReOpenableHashPartition(TypeSerializer<BT> buildSideAccessors, TypeSerializer<PT> probeSideAccessors, int partitionNumber, int recursionLevel, MemorySegment initialBuffer, MemorySegmentSource memSource, int segmentSize) {
        super(buildSideAccessors, probeSideAccessors, partitionNumber, recursionLevel, initialBuffer, memSource, segmentSize);
    }

    @Override
    public int finalizeProbePhase(List<MemorySegment> freeMemory, List<HashPartition<BT, PT>> spilledPartitions) throws IOException {
        if (this.furtherPartitioning || this.recursionLevel != 0 || this.isRestored) {
            if (this.isInMemory() && this.initialBuildSideChannel != null && !this.isRestored) {
                for (int k = 0; k < this.numOverflowSegments; ++k) {
                    freeMemory.add(this.overflowSegments[k]);
                }
                this.overflowSegments = null;
                this.numOverflowSegments = 0;
                this.nextOverflowBucket = 0;
                return 0;
            }
            return super.finalizeProbePhase(freeMemory, spilledPartitions);
        }
        if (!this.isInMemory() && this.probeSideRecordCounter == 0L) {
            freeMemory.add(this.probeSideBuffer.getCurrentSegment());
            this.probeSideChannel.close();
            this.probeSideChannel.deleteChannel();
            return 0;
        }
        if (this.isInMemory()) {
            return 0;
        }
        this.probeSideBuffer.close();
        this.probeSideChannel.close();
        spilledPartitions.add(this);
        return 1;
    }

    int spillInMemoryPartition(Channel.ID targetChannel, IOManager ioManager, LinkedBlockingQueue<MemorySegment> writeBehindBuffers) throws IOException {
        this.initialPartitionBuffersCount = this.partitionBuffers.length;
        this.initialBuildSideChannel = targetChannel;
        this.initialBuildSideWriter = ioManager.createBlockChannelWriter(targetChannel, writeBehindBuffers);
        int numSegments = this.partitionBuffers.length;
        for (int i = 0; i < numSegments; ++i) {
            this.initialBuildSideWriter.writeBlock(this.partitionBuffers[i]);
        }
        this.partitionBuffers = null;
        this.initialBuildSideWriter.close();
        return numSegments;
    }

    void restorePartitionBuffers(IOManager ioManager, List<MemorySegment> availableMemory) throws IOException {
        BulkBlockChannelReader reader = ioManager.createBulkBlockChannelReader(this.initialBuildSideChannel, availableMemory, this.initialPartitionBuffersCount);
        reader.close();
        List<MemorySegment> partitionBuffersFromDisk = reader.getFullSegments();
        this.partitionBuffers = partitionBuffersFromDisk.toArray(new MemorySegment[partitionBuffersFromDisk.size()]);
        this.overflowSegments = new MemorySegment[2];
        this.numOverflowSegments = 0;
        this.nextOverflowBucket = 0;
        this.isRestored = true;
    }

    @Override
    public void clearAllMemory(List<MemorySegment> target) {
        if (this.initialBuildSideChannel != null) {
            try {
                this.initialBuildSideWriter.closeAndDelete();
            }
            catch (IOException ioex) {
                throw new RuntimeException("Error deleting the partition files. Some temporary files might not be removed.");
            }
        }
        super.clearAllMemory(target);
    }
}

