/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerFactory;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.memorymanager.MemoryManager;
import org.apache.flink.runtime.operators.DriverStrategy;
import org.apache.flink.runtime.operators.PactDriver;
import org.apache.flink.runtime.operators.PactTaskContext;
import org.apache.flink.runtime.operators.sort.FixedLengthRecordSorter;
import org.apache.flink.runtime.operators.sort.InMemorySorter;
import org.apache.flink.runtime.operators.sort.NormalizedKeySorter;
import org.apache.flink.runtime.operators.sort.QuickSort;
import org.apache.flink.util.Collector;
import org.apache.flink.util.MutableObjectIterator;

public class ReduceCombineDriver<T>
implements PactDriver<ReduceFunction<T>, T> {
    private static final Log LOG = LogFactory.getLog(ReduceCombineDriver.class);
    private static final int THRESHOLD_FOR_IN_PLACE_SORTING = 32;
    private PactTaskContext<ReduceFunction<T>, T> taskContext;
    private TypeSerializer<T> serializer;
    private TypeComparator<T> comparator;
    private ReduceFunction<T> reducer;
    private Collector<T> output;
    private MemoryManager memManager;
    private InMemorySorter<T> sorter;
    private QuickSort sortAlgo = new QuickSort();
    private boolean running;

    @Override
    public void setup(PactTaskContext<ReduceFunction<T>, T> context) {
        this.taskContext = context;
        this.running = true;
    }

    @Override
    public int getNumberOfInputs() {
        return 1;
    }

    @Override
    public Class<ReduceFunction<T>> getStubType() {
        Class<ReduceFunction> clazz = ReduceFunction.class;
        return clazz;
    }

    @Override
    public boolean requiresComparatorOnInput() {
        return true;
    }

    @Override
    public void prepare() throws Exception {
        if (this.taskContext.getTaskConfig().getDriverStrategy() != DriverStrategy.SORTED_PARTIAL_REDUCE) {
            throw new Exception("Invalid strategy " + (Object)((Object)this.taskContext.getTaskConfig().getDriverStrategy()) + " for reduce combiner.");
        }
        this.memManager = this.taskContext.getMemoryManager();
        int numMemoryPages = this.memManager.computeNumberOfPages(this.taskContext.getTaskConfig().getRelativeMemoryDriver());
        TypeSerializerFactory serializerFactory = this.taskContext.getInputSerializer(0);
        this.serializer = serializerFactory.getSerializer();
        this.comparator = this.taskContext.getInputComparator(0);
        this.serializer = serializerFactory.getSerializer();
        this.reducer = this.taskContext.getStub();
        this.output = this.taskContext.getOutputCollector();
        List<MemorySegment> memory = this.memManager.allocatePages(this.taskContext.getOwningNepheleTask(), numMemoryPages);
        this.sorter = this.comparator.supportsSerializationWithKeyNormalization() && this.serializer.getLength() > 0 && this.serializer.getLength() <= 32 ? new FixedLengthRecordSorter<T>(this.serializer, this.comparator, memory) : new NormalizedKeySorter<T>(this.serializer, this.comparator.duplicate(), memory);
    }

    @Override
    public void run() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Combiner starting.");
        }
        MutableObjectIterator in = this.taskContext.getInput(0);
        TypeSerializer<T> serializer = this.serializer;
        Object value = serializer.createInstance();
        while (this.running && (value = in.next(value)) != null) {
            if (this.sorter.write(value)) continue;
            this.sortAndCombine();
            this.sorter.reset();
            if (this.sorter.write(value)) continue;
            throw new IOException("Cannot write record to fresh sort buffer. Record too large.");
        }
        this.sortAndCombine();
    }

    private void sortAndCombine() throws Exception {
        InMemorySorter<T> sorter = this.sorter;
        if (!sorter.isEmpty()) {
            this.sortAlgo.sort(sorter);
            TypeSerializer<T> serializer = this.serializer;
            TypeComparator<T> comparator = this.comparator;
            ReduceFunction<T> function = this.reducer;
            Collector<T> output = this.output;
            MutableObjectIterator<T> input = sorter.getIterator();
            Object value = input.next(serializer.createInstance());
            while (this.running && value != null) {
                comparator.setReference(value);
                Object res = value;
                while ((value = input.next(serializer.createInstance())) != null && comparator.equalToReference(value)) {
                    res = function.reduce(res, value);
                }
                output.collect(res);
            }
        }
    }

    @Override
    public void cleanup() {
        this.memManager.release(this.sorter.dispose());
    }

    @Override
    public void cancel() {
        this.running = false;
        this.memManager.release(this.sorter.dispose());
    }
}

