/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators;

import java.util.Collections;
import java.util.Set;
import org.apache.flink.api.common.functions.CoGroupFunction;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypePairComparator;
import org.apache.flink.api.common.typeutils.TypePairComparatorFactory;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.iterative.concurrent.SolutionSetBroker;
import org.apache.flink.runtime.iterative.task.AbstractIterativePactTask;
import org.apache.flink.runtime.operators.PactTaskContext;
import org.apache.flink.runtime.operators.ResettablePactDriver;
import org.apache.flink.runtime.operators.hash.AbstractHashTableProber;
import org.apache.flink.runtime.operators.hash.CompactingHashTable;
import org.apache.flink.runtime.util.KeyGroupedIterator;
import org.apache.flink.runtime.util.SingleElementIterator;
import org.apache.flink.util.Collector;

public class CoGroupWithSolutionSetFirstDriver<IT1, IT2, OT>
implements ResettablePactDriver<CoGroupFunction<IT1, IT2, OT>, OT> {
    private PactTaskContext<CoGroupFunction<IT1, IT2, OT>, OT> taskContext;
    private CompactingHashTable<IT1> hashTable;
    private TypeSerializer<IT2> probeSideSerializer;
    private TypeComparator<IT2> probeSideComparator;
    private TypePairComparator<IT2, IT1> pairComparator;
    private IT1 solutionSideRecord;
    protected volatile boolean running;

    @Override
    public void setup(PactTaskContext<CoGroupFunction<IT1, IT2, OT>, OT> context) {
        this.taskContext = context;
        this.running = true;
    }

    @Override
    public int getNumberOfInputs() {
        return 1;
    }

    @Override
    public Class<CoGroupFunction<IT1, IT2, OT>> getStubType() {
        Class<CoGroupFunction> clazz = CoGroupFunction.class;
        return clazz;
    }

    @Override
    public boolean requiresComparatorOnInput() {
        return true;
    }

    @Override
    public boolean isInputResettable(int inputNum) {
        if (inputNum < 0 || inputNum > 1) {
            throw new IndexOutOfBoundsException();
        }
        return false;
    }

    @Override
    public void initialize() {
        if (!(this.taskContext instanceof AbstractIterativePactTask)) {
            throw new RuntimeException("The task context of this driver is no iterative task context.");
        }
        AbstractIterativePactTask iterativeTaskContext = (AbstractIterativePactTask)this.taskContext;
        String identifier = iterativeTaskContext.brokerKey();
        this.hashTable = SolutionSetBroker.instance().get(identifier);
        TypeSerializer buildSideSerializer = this.hashTable.getBuildSideSerializer();
        TypeComparator buildSideComparator = this.hashTable.getBuildSideComparator().duplicate();
        this.probeSideSerializer = this.taskContext.getInputSerializer(0).getSerializer();
        this.probeSideComparator = this.taskContext.getInputComparator(0);
        this.solutionSideRecord = buildSideSerializer.createInstance();
        TypePairComparatorFactory pairCompFactory = this.taskContext.getTaskConfig().getPairComparatorFactory(this.taskContext.getUserCodeClassLoader());
        this.pairComparator = pairCompFactory.createComparator21(buildSideComparator, this.probeSideComparator);
    }

    @Override
    public void prepare() {
    }

    @Override
    public void run() throws Exception {
        CoGroupFunction<IT1, IT2, OT> coGroupStub = this.taskContext.getStub();
        Collector<OT> collector = this.taskContext.getOutputCollector();
        IT1 buildSideRecord = this.solutionSideRecord;
        CompactingHashTable<IT1> join = this.hashTable;
        KeyGroupedIterator probeSideInput = new KeyGroupedIterator(this.taskContext.getInput(0), this.probeSideSerializer, this.probeSideComparator);
        SingleElementIterator<IT1> siIter = new SingleElementIterator<IT1>();
        Set emptySolutionSide = Collections.emptySet();
        AbstractHashTableProber prober = join.getProber((TypeComparator)this.probeSideComparator, (TypePairComparator)this.pairComparator);
        while (this.running && probeSideInput.nextKey()) {
            Object current = probeSideInput.getCurrent();
            if (((CompactingHashTable.HashTableProber)prober).getMatchFor(current, buildSideRecord)) {
                siIter.set(buildSideRecord);
                coGroupStub.coGroup(siIter, (Iterable)probeSideInput.getValues(), collector);
                continue;
            }
            coGroupStub.coGroup(emptySolutionSide, (Iterable)probeSideInput.getValues(), collector);
        }
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void reset() {
    }

    @Override
    public void teardown() {
    }

    @Override
    public void cancel() {
        this.running = false;
    }
}

