/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager.splitassigner;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.core.io.LocatableInputSplit;
import org.apache.flink.runtime.executiongraph.ExecutionGroupVertex;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.instance.Instance;
import org.apache.flink.runtime.jobmanager.splitassigner.InputSplitAssigner;
import org.apache.flink.runtime.jobmanager.splitassigner.LocatableInputSplitList;

public final class LocatableInputSplitAssigner
implements InputSplitAssigner {
    private static final Log LOG = LogFactory.getLog(LocatableInputSplitAssigner.class);
    private final ConcurrentMap<ExecutionGroupVertex, LocatableInputSplitList> vertexMap = new ConcurrentHashMap<ExecutionGroupVertex, LocatableInputSplitList>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerGroupVertex(ExecutionGroupVertex groupVertex) {
        if (!LocatableInputSplit.class.isAssignableFrom(groupVertex.getInputSplitType())) {
            LOG.error((Object)(groupVertex.getName() + " produces input splits of type " + groupVertex.getInputSplitType() + " and cannot be handled by this split assigner"));
            return;
        }
        InputSplit[] inputSplits = groupVertex.getInputSplits();
        if (inputSplits == null) {
            return;
        }
        if (inputSplits.length == 0) {
            return;
        }
        LocatableInputSplitList splitStore = new LocatableInputSplitList();
        if (this.vertexMap.putIfAbsent(groupVertex, splitStore) != null) {
            LOG.error((Object)(groupVertex.getName() + " appears to be already registered with the locatable input split assigner, ignoring vertex..."));
            return;
        }
        LocatableInputSplitList locatableInputSplitList = splitStore;
        synchronized (locatableInputSplitList) {
            for (int i = 0; i < inputSplits.length; ++i) {
                InputSplit inputSplit = inputSplits[i];
                if (!(inputSplit instanceof LocatableInputSplit)) {
                    LOG.error((Object)("Input split " + i + " of vertex " + groupVertex.getName() + " is of type " + inputSplit.getClass() + ", ignoring split..."));
                    continue;
                }
                splitStore.addSplit((LocatableInputSplit)inputSplit);
            }
        }
    }

    @Override
    public void unregisterGroupVertex(ExecutionGroupVertex groupVertex) {
        this.vertexMap.remove(groupVertex);
    }

    @Override
    public InputSplit getNextInputSplit(ExecutionVertex vertex) {
        ExecutionGroupVertex groupVertex = vertex.getGroupVertex();
        LocatableInputSplitList splitStore = (LocatableInputSplitList)this.vertexMap.get(groupVertex);
        if (splitStore == null) {
            return null;
        }
        Instance instance = vertex.getAllocatedResource().getInstance();
        if (instance == null) {
            LOG.error((Object)"Instance is null, returning random split");
            return null;
        }
        return splitStore.getNextInputSplit(instance);
    }
}

