/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.gates;

import java.io.IOException;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.runtime.deployment.ChannelDeploymentDescriptor;
import org.apache.flink.runtime.deployment.GateDeploymentDescriptor;
import org.apache.flink.runtime.event.task.AbstractEvent;
import org.apache.flink.runtime.io.network.Buffer;
import org.apache.flink.runtime.io.network.channels.ChannelID;
import org.apache.flink.runtime.io.network.channels.OutputChannel;
import org.apache.flink.runtime.io.network.gates.Gate;
import org.apache.flink.runtime.io.network.gates.GateID;
import org.apache.flink.runtime.jobgraph.JobID;

public class OutputGate
extends Gate<IOReadableWritable> {
    private OutputChannel[] channels;
    private boolean closed;

    public OutputGate(JobID jobId, GateID gateId, int index) {
        super(jobId, gateId, index);
    }

    public void sendBuffer(Buffer buffer, int targetChannel) throws IOException, InterruptedException {
        this.channels[targetChannel].sendBuffer(buffer);
    }

    public void sendEvent(AbstractEvent event, int targetChannel) throws IOException, InterruptedException {
        this.channels[targetChannel].sendEvent(event);
    }

    public void sendBufferAndEvent(Buffer buffer, AbstractEvent event, int targetChannel) throws IOException, InterruptedException {
        this.channels[targetChannel].sendBufferAndEvent(buffer, event);
    }

    public void broadcastBuffer(Buffer buffer) throws IOException, InterruptedException {
        for (int i = 1; i < this.channels.length; ++i) {
            this.channels[i].sendBuffer(buffer.duplicate());
        }
        this.channels[0].sendBuffer(buffer);
    }

    public void broadcastEvent(AbstractEvent event) throws IOException, InterruptedException {
        for (OutputChannel channel : this.channels) {
            channel.sendEvent(event);
        }
    }

    public void initializeChannels(GateDeploymentDescriptor descriptor) {
        int numChannels = descriptor.getNumberOfChannelDescriptors();
        this.channels = new OutputChannel[numChannels];
        this.setChannelType(descriptor.getChannelType());
        for (int i = 0; i < numChannels; ++i) {
            ChannelDeploymentDescriptor channelDescriptor = descriptor.getChannelDescriptor(i);
            ChannelID id = channelDescriptor.getOutputChannelID();
            ChannelID connectedId = channelDescriptor.getInputChannelID();
            this.channels[i] = new OutputChannel(this, i, id, connectedId, this.getChannelType());
        }
    }

    public OutputChannel[] channels() {
        return this.channels;
    }

    public OutputChannel getChannel(int index) {
        return index < this.channels.length ? this.channels[index] : null;
    }

    public int getNumChannels() {
        return this.channels.length;
    }

    public void requestClose() throws IOException, InterruptedException {
        for (OutputChannel channel : this.channels) {
            channel.requestClose();
        }
    }

    @Override
    public boolean isClosed() {
        if (this.closed) {
            return true;
        }
        for (OutputChannel channel : this.channels) {
            if (channel.isClosed()) continue;
            return false;
        }
        this.closed = true;
        return true;
    }

    public void waitForGateToBeClosed() throws InterruptedException {
        if (this.closed) {
            return;
        }
        for (OutputChannel channel : this.channels) {
            channel.waitForChannelToBeClosed();
        }
        this.closed = true;
    }

    @Override
    public boolean isInputGate() {
        return false;
    }

    @Override
    public String toString() {
        return "Output " + super.toString();
    }

    @Override
    public void publishEvent(AbstractEvent event) throws IOException, InterruptedException {
    }

    @Override
    public void releaseAllChannelResources() {
    }
}

