/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.disk.iomanager;

import java.io.IOException;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.disk.iomanager.BlockChannelAccess;
import org.apache.flink.runtime.io.disk.iomanager.WriteRequest;

final class SegmentWriteRequest
implements WriteRequest {
    private final BlockChannelAccess<WriteRequest, ?> channel;
    private final MemorySegment segment;

    protected SegmentWriteRequest(BlockChannelAccess<WriteRequest, ?> targetChannel, MemorySegment segment) {
        this.channel = targetChannel;
        this.segment = segment;
    }

    @Override
    public void write() throws IOException {
        try {
            this.channel.fileChannel.write(this.segment.wrap(0, this.segment.size()));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public void requestDone(IOException ioex) {
        this.channel.handleProcessedBuffer(this.segment, ioex);
    }
}

