/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.instance;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.runtime.ExecutionMode;
import org.apache.flink.runtime.instance.DefaultInstanceManager;
import org.apache.flink.runtime.taskmanager.TaskManager;

public class LocalInstanceManager
extends DefaultInstanceManager {
    private List<TaskManager> taskManagers = new ArrayList<TaskManager>();

    public LocalInstanceManager() throws Exception {
        int numTaskManager = GlobalConfiguration.getInteger((String)"localinstancemanager.numtaskmanager", (int)1);
        ExecutionMode execMode = numTaskManager == 1 ? ExecutionMode.LOCAL : ExecutionMode.CLUSTER;
        for (int i = 0; i < numTaskManager; ++i) {
            Configuration tm = new Configuration();
            int ipcPort = GlobalConfiguration.getInteger((String)"taskmanager.rpc.port", (int)6122);
            int dataPort = GlobalConfiguration.getInteger((String)"taskmanager.data.port", (int)6121);
            tm.setInteger("taskmanager.rpc.port", ipcPort + i);
            tm.setInteger("taskmanager.data.port", dataPort + i);
            GlobalConfiguration.includeConfiguration((Configuration)tm);
            this.taskManagers.add(new TaskManager(execMode));
        }
    }

    @Override
    public void shutdown() {
        for (TaskManager taskManager : this.taskManagers) {
            taskManager.shutdown();
        }
        super.shutdown();
    }
}

