/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.execution;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.runtime.execution.ExecutionState;

public final class ExecutionStateTransition {
    private static final Log LOG = LogFactory.getLog(ExecutionStateTransition.class);

    private ExecutionStateTransition() {
    }

    public static void checkTransition(boolean jobManager, String taskName, ExecutionState oldState, ExecutionState newState) {
        LOG.info((Object)((jobManager ? "JM: " : "TM: ") + "ExecutionState set from " + (Object)((Object)oldState) + " to " + (Object)((Object)newState) + " for task " + taskName));
        boolean unexpectedStateChange = true;
        if (oldState == ExecutionState.CREATED && newState == ExecutionState.SCHEDULED) {
            unexpectedStateChange = false;
        } else if (oldState == ExecutionState.SCHEDULED && newState == ExecutionState.ASSIGNED) {
            unexpectedStateChange = false;
        } else if (oldState == ExecutionState.ASSIGNED && newState == ExecutionState.READY) {
            unexpectedStateChange = false;
        } else if (oldState == ExecutionState.READY && newState == ExecutionState.STARTING) {
            unexpectedStateChange = false;
        } else if (oldState == ExecutionState.STARTING && newState == ExecutionState.RUNNING) {
            unexpectedStateChange = false;
        } else if (oldState == ExecutionState.RUNNING && newState == ExecutionState.FINISHING) {
            unexpectedStateChange = false;
        } else if (oldState == ExecutionState.FINISHING && newState == ExecutionState.FINISHED) {
            unexpectedStateChange = false;
        } else if (oldState == ExecutionState.CREATED && newState == ExecutionState.ASSIGNED) {
            unexpectedStateChange = false;
        } else if (oldState == ExecutionState.SCHEDULED && newState == ExecutionState.CANCELING) {
            unexpectedStateChange = false;
        } else if (oldState == ExecutionState.ASSIGNED && newState == ExecutionState.CANCELING) {
            unexpectedStateChange = false;
        } else if (oldState == ExecutionState.READY && newState == ExecutionState.CANCELING) {
            unexpectedStateChange = false;
        } else if (newState == ExecutionState.FAILED || newState == ExecutionState.CANCELED || newState == ExecutionState.CANCELING) {
            unexpectedStateChange = false;
        }
        if (unexpectedStateChange) {
            LOG.error((Object)("Unexpected state change: " + (Object)((Object)oldState) + " -> " + (Object)((Object)newState)));
        }
    }
}

