/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.execution;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.FutureTask;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.network.bufferprovider.BufferProvider;
import org.apache.flink.runtime.io.network.channels.ChannelID;
import org.apache.flink.runtime.io.network.gates.GateID;
import org.apache.flink.runtime.io.network.gates.InputGate;
import org.apache.flink.runtime.io.network.gates.OutputGate;
import org.apache.flink.runtime.jobgraph.JobID;
import org.apache.flink.runtime.jobgraph.tasks.InputSplitProvider;
import org.apache.flink.runtime.memorymanager.MemoryManager;
import org.apache.flink.runtime.protocols.AccumulatorProtocol;

public interface Environment {
    public JobID getJobID();

    public Configuration getTaskConfiguration();

    public Configuration getJobConfiguration();

    public int getCurrentNumberOfSubtasks();

    public int getIndexInSubtaskGroup();

    public void userThreadStarted(Thread var1);

    public void userThreadFinished(Thread var1);

    public InputSplitProvider getInputSplitProvider();

    public IOManager getIOManager();

    public MemoryManager getMemoryManager();

    public String getTaskName();

    public GateID getNextUnboundInputGateID();

    public int getNumberOfOutputGates();

    public int getNumberOfInputGates();

    public int getNumberOfOutputChannels();

    public int getNumberOfInputChannels();

    public OutputGate createAndRegisterOutputGate();

    public <T extends IOReadableWritable> InputGate<T> createAndRegisterInputGate();

    public Set<ChannelID> getOutputChannelIDs();

    public Set<ChannelID> getInputChannelIDs();

    public Set<GateID> getOutputGateIDs();

    public Set<GateID> getInputGateIDs();

    public Set<ChannelID> getOutputChannelIDsOfGate(GateID var1);

    public Set<ChannelID> getInputChannelIDsOfGate(GateID var1);

    public AccumulatorProtocol getAccumulatorProtocolProxy();

    public BufferProvider getOutputBufferProvider();

    public Map<String, FutureTask<Path>> getCopyTask();
}

