/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.event.job;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.flink.core.io.StringRecord;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.event.job.AbstractEvent;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.util.EnumUtils;

public class VertexEvent
extends AbstractEvent {
    private JobVertexID jobVertexID;
    private String jobVertexName;
    private int totalNumberOfSubtasks;
    private int indexOfSubtask;
    private ExecutionState currentExecutionState;
    private String description;

    public VertexEvent(long timestamp, JobVertexID jobVertexID, String jobVertexName, int totalNumberOfSubtasks, int indexOfSubtask, ExecutionState currentExecutionState, String description) {
        super(timestamp);
        this.jobVertexID = jobVertexID;
        this.jobVertexName = jobVertexName;
        this.totalNumberOfSubtasks = totalNumberOfSubtasks;
        this.indexOfSubtask = indexOfSubtask;
        this.currentExecutionState = currentExecutionState;
        this.description = description;
    }

    public VertexEvent() {
        this.jobVertexID = new JobVertexID();
        this.jobVertexName = null;
        this.totalNumberOfSubtasks = -1;
        this.indexOfSubtask = -1;
        this.currentExecutionState = ExecutionState.CREATED;
        this.description = null;
    }

    @Override
    public void read(DataInputView in) throws IOException {
        super.read(in);
        this.jobVertexID.read(in);
        this.jobVertexName = StringRecord.readString((DataInput)in);
        this.totalNumberOfSubtasks = in.readInt();
        this.indexOfSubtask = in.readInt();
        this.currentExecutionState = EnumUtils.readEnum((DataInput)in, ExecutionState.class);
        this.description = StringRecord.readString((DataInput)in);
    }

    @Override
    public void write(DataOutputView out) throws IOException {
        super.write(out);
        this.jobVertexID.write(out);
        StringRecord.writeString((DataOutput)out, (String)this.jobVertexName);
        out.writeInt(this.totalNumberOfSubtasks);
        out.writeInt(this.indexOfSubtask);
        EnumUtils.writeEnum((DataOutput)out, this.currentExecutionState);
        StringRecord.writeString((DataOutput)out, (String)this.description);
    }

    public JobVertexID getJobVertexID() {
        return this.jobVertexID;
    }

    public String getJobVertexName() {
        return this.jobVertexName;
    }

    public int getTotalNumberOfSubtasks() {
        return this.totalNumberOfSubtasks;
    }

    public int getIndexOfSubtask() {
        return this.indexOfSubtask;
    }

    public ExecutionState getCurrentExecutionState() {
        return this.currentExecutionState;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return VertexEvent.timestampToString(this.getTimestamp()) + ":\t" + this.jobVertexName + " (" + (this.indexOfSubtask + 1) + "/" + this.totalNumberOfSubtasks + ") switched to " + (Object)((Object)this.currentExecutionState) + (this.description != null ? "\n" + this.description : "");
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof VertexEvent)) {
            return false;
        }
        VertexEvent vertexEvent = (VertexEvent)obj;
        if (!this.jobVertexID.equals(vertexEvent.getJobVertexID())) {
            return false;
        }
        if (this.jobVertexName != null && vertexEvent.getJobVertexName() != null ? !this.jobVertexName.equals(vertexEvent.getJobVertexName()) : this.jobVertexName != vertexEvent.getJobVertexName()) {
            return false;
        }
        if (this.totalNumberOfSubtasks != vertexEvent.getTotalNumberOfSubtasks()) {
            return false;
        }
        if (this.indexOfSubtask != vertexEvent.getIndexOfSubtask()) {
            return false;
        }
        if (!this.currentExecutionState.equals((Object)vertexEvent.getCurrentExecutionState())) {
            return false;
        }
        return !(this.description != null && vertexEvent.getDescription() != null ? !this.description.equals(vertexEvent.getDescription()) : this.description != vertexEvent.getDescription());
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

